/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.rest.RestLanguage;
import com.jetbrains.rest.RestPythonElementTypes;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RestFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private Set<Language> myLanguages;

    public RestFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        RestLanguage restLanguage = RestLanguage.INSTANCE;
        if (restLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/RestFileViewProvider", "getBaseLanguage"));
        }
        return restLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        if (pythonLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/RestFileViewProvider", "getTemplateDataLanguage"));
        }
        return pythonLanguage;
    }

    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile virtualFile) {
        return new RestFileViewProvider(this.getManager(), virtualFile, false);
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myLanguages == null) {
            this.myLanguages = Sets.newLinkedHashSet();
            this.myLanguages.add(this.getBaseLanguage());
            Language djangoTemplateLanguage = Language.findLanguageByID((String)"DjangoTemplate");
            if (djangoTemplateLanguage != null) {
                this.myLanguages.add(djangoTemplateLanguage);
            }
            this.myLanguages.add(this.getTemplateDataLanguage());
        }
        Set<Language> set = this.myLanguages;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/RestFileViewProvider", "getLanguages"));
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/rest/RestFileViewProvider", "createFile"));
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (def == null) {
            return null;
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)RestPythonElementTypes.PYTHON_BLOCK_DATA);
            return file;
        }
        if (lang.getID().equals("DjangoTemplate")) {
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)RestPythonElementTypes.DJANGO_BLOCK_DATA);
            return file;
        }
        if (lang == RestLanguage.INSTANCE) {
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }
}

