/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.rest.psi.RestElement;
import com.jetbrains.rest.psi.RestTitle;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestStructureViewElement
implements StructureViewTreeElement {
    private NavigatablePsiElement myElement;

    public RestStructureViewElement(NavigatablePsiElement element) {
        this.myElement = element;
    }

    public NavigatablePsiElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        final LinkedHashSet childrenElements = new LinkedHashSet();
        this.myElement.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof RestTitle && ((RestTitle)element).getName() != null) {
                    childrenElements.add((RestElement)element);
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        StructureViewTreeElement[] children = new StructureViewTreeElement[childrenElements.size()];
        int i = 0;
        for (RestElement element : childrenElements) {
            children[i] = new RestStructureViewElement(element);
            ++i;
        }
        if (children == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/structureView/RestStructureViewElement", "getChildren"));
        }
        return children;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return RestStructureViewElement.this.myElement.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/structureView/RestStructureViewElement", "getPresentation"));
        }
        return itemPresentation;
    }
}

