/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.psi;

import com.intellij.lang.ASTNode;
import com.jetbrains.rest.psi.RestElement;
import com.jetbrains.rest.validation.RestElementVisitor;
import java.text.StringCharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestTitle
extends RestElement {
    public RestTitle(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/rest/psi/RestTitle", "<init>"));
        }
        super(node);
    }

    @Override
    public String toString() {
        return "RestTitle:" + this.getNode().getElementType().toString();
    }

    @Nullable
    public String getName() {
        String text = this.getNode().getText().trim();
        if (text.length() < 2) {
            return null;
        }
        char adorn = text.charAt(text.length() - 2);
        StringCharacterIterator it = new StringCharacterIterator(text);
        int finish = 0;
        char ch = it.last();
        while (ch != '\uffff') {
            if (ch != adorn) {
                finish = it.getIndex();
                break;
            }
            ch = it.previous();
        }
        int start = 0;
        if (text.charAt(0) == adorn) {
            char ch2 = it.first();
            while (ch2 != '\uffff') {
                if (ch2 != adorn) {
                    start = it.getIndex() + 1;
                    break;
                }
                ch2 = it.next();
            }
        }
        if (finish <= 0 || start < 0) {
            return null;
        }
        return text.substring(start, finish).trim();
    }

    @Nullable
    public String getUnderline() {
        String text = this.getNode().getText().trim();
        if (text.length() < 2) {
            return null;
        }
        char adorn = text.charAt(text.length() - 2);
        StringCharacterIterator it = new StringCharacterIterator(text);
        int start = 0;
        char ch = it.last();
        while (ch != '\uffff') {
            if (ch != adorn) {
                start = it.getIndex() + 1;
                break;
            }
            ch = it.previous();
        }
        return text.substring(start, text.length());
    }

    @Override
    protected void acceptRestVisitor(RestElementVisitor visitor) {
        visitor.visitTitle(this);
    }
}

