/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.rest.RestLanguage;
import com.jetbrains.rest.formatter.RestBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestFormattingModelBuilder
implements FormattingModelBuilderEx,
CustomFormattingModelBuilder {
    public boolean isEngagedToFormat(PsiElement context) {
        PsiFile file = context.getContainingFile();
        return file != null && file.getLanguage() == RestLanguage.INSTANCE;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        return null;
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "createModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "createModel"));
        }
        RestBlock block = new RestBlock(null, element.getNode(), null, Indent.getNoneIndent(), null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/formatter/RestFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        PsiElement element = elementAtOffset.getPsi();
        PsiElement container = element.getParent();
        return container != null ? container.getTextRange() : null;
    }
}

