/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.rest.RestTokenTypes;
import com.jetbrains.rest.psi.RestElement;
import com.jetbrains.rest.psi.RestReference;
import com.jetbrains.rest.psi.RestReferenceTarget;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ReferenceCompletionContributor
extends CompletionContributor {
    public static final PsiElementPattern.Capture<PsiElement> REFERENCE_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)RestTokenTypes.EXPLISIT_MARKUP_START));
    public static final PsiElementPattern.Capture<PsiElement> PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent(REFERENCE_PATTERN), REFERENCE_PATTERN});

    public ReferenceCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/rest/completion/ReferenceCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/rest/completion/ReferenceCompletionContributor$1", "addCompletions"));
                }
                PsiElement original = parameters.getPosition();
                PsiFile file = original.getContainingFile();
                int offset = parameters.getOffset();
                String prefix = this.getPrefix(offset, file);
                if (prefix.length() > 0) {
                    result = result.withPrefixMatcher(prefix);
                }
                RestReference[] elements = (RestReference[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReference.class);
                RestReferenceTarget[] targets = (RestReferenceTarget[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReferenceTarget.class);
                HashSet<String> names = new HashSet<String>();
                if (targets != null) {
                    for (RestElement restElement : targets) {
                        names.add(((RestReferenceTarget)restElement).getReferenceName());
                    }
                }
                if (elements != null) {
                    for (RestElement restElement : elements) {
                        String name = ((RestReference)restElement).getReferenceText();
                        if (names.contains(name)) continue;
                        if (name.startsWith("[") && name.endsWith("]") || name.startsWith("|") && name.endsWith("|")) {
                            result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                            continue;
                        }
                        if (name.equals("__")) {
                            result.addElement((LookupElement)LookupElementBuilder.create((String)(name + ":")));
                            continue;
                        }
                        if (name.startsWith("_")) {
                            name = "\\" + name;
                        }
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("_" + name + ":")));
                    }
                }
            }

            private String getPrefix(int offset, PsiFile file) {
                if (offset > 0) {
                    --offset;
                }
                String text = file.getText();
                StringBuilder prefixBuilder = new StringBuilder();
                while (offset > 0 && (Character.isLetterOrDigit(text.charAt(offset)) || text.charAt(offset) == '_' || text.charAt(offset) == '[') || text.charAt(offset) == '|') {
                    prefixBuilder.insert(0, text.charAt(offset));
                    if (text.charAt(offset) == '_' || text.charAt(offset) == '[' || text.charAt(offset) == '|') break;
                    --offset;
                }
                return prefixBuilder.toString();
            }
        });
    }
}

