/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.WinPty;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NamedPipe {
    private WinNT.HANDLE myHandle;
    private boolean writeNotify = false;
    private boolean wrote = false;
    private boolean readNotify = false;

    public NamedPipe(WinNT.HANDLE handle) {
        this.myHandle = handle;
    }

    public boolean write(byte[] buf, int len) throws IOException {
        boolean wSuccess = false;
        if (len < 0) {
            len = 0;
        }
        try {
            while (this.readNotify) {
            }
            this.writeNotify = true;
            NamedPipe.write0(this.myHandle, buf, len);
            this.wrote = true;
        }
        catch (IOException e) {
            throw new IOException("IO Exception while writing to the pipe.", e);
        }
        finally {
            this.writeNotify = false;
        }
        return wSuccess;
    }

    public int read(byte[] buf, int len) throws IOException {
        int byteTransfer = -1;
        if (len < 0) {
            len = 0;
        }
        long curLength = 0L;
        while (curLength == 0L) {
            if (this.myHandle == null) {
                return 0;
            }
            try {
                curLength = NamedPipe.available(this.myHandle);
            }
            catch (IOException e) {
                curLength = -1L;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                curLength = -1L;
            }
        }
        if (curLength == -1L) {
            return byteTransfer;
        }
        if (!this.wrote && curLength > 0L) {
            try {
                while (this.writeNotify) {
                }
                this.readNotify = true;
                byteTransfer = NamedPipe.read0(this.myHandle, buf, len);
            }
            catch (IOException e) {
                throw new IOException("IO Exception while reading from the pipe.", e);
            }
            finally {
                this.readNotify = false;
            }
        }
        if (this.wrote && curLength > 0L) {
            try {
                while (this.writeNotify) {
                }
                this.readNotify = true;
                byteTransfer = NamedPipe.read0(this.myHandle, buf, len);
            }
            catch (IOException e) {
                throw new IOException("IO Exception while reading from the pipe.", e);
            }
            finally {
                this.wrote = false;
                this.readNotify = false;
            }
        }
        return byteTransfer;
    }

    public int available() throws IOException {
        return (int)NamedPipe.available(this.myHandle);
    }

    private static long available(WinNT.HANDLE handle) throws IOException {
        if (handle == null) {
            return -1L;
        }
        IntByReference read = new IntByReference(0);
        ByteBuffer b = ByteBuffer.wrap(new byte[10]);
        if (!WinPty.KERNEL32.PeekNamedPipe(handle, b, b.capacity(), new IntByReference(), read, new IntByReference())) {
            throw new IOException("Cant peek named pipe");
        }
        return read.getValue();
    }

    private static int read0(WinNT.HANDLE handle, byte[] b, int len) throws IOException {
        if (handle == null) {
            return -1;
        }
        IntByReference dwRead = new IntByReference();
        ByteBuffer buf = ByteBuffer.wrap(b);
        WinPty.KERNEL32.ReadFile(handle, buf, len, dwRead, null);
        return dwRead.getValue();
    }

    private static int write0(WinNT.HANDLE handle, byte[] b, int len) throws IOException {
        if (handle == null) {
            return -1;
        }
        IntByReference dwWritten = new IntByReference();
        Kernel32.INSTANCE.WriteFile(handle, b, len, dwWritten, null);
        return dwWritten.getValue();
    }

    public void markClosed() {
        this.myHandle = null;
    }

    public void close() throws IOException {
        if (this.myHandle == null) {
            return;
        }
        boolean status = NamedPipe.close0(this.myHandle);
        if (!status) {
            throw new IOException("Close error:" + Kernel32.INSTANCE.GetLastError());
        }
        this.myHandle = null;
    }

    public static boolean close0(WinNT.HANDLE handle) throws IOException {
        return Kernel32.INSTANCE.CloseHandle(handle);
    }
}

