/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.Pty;
import com.pty4j.unix.PtyExecutor;
import com.pty4j.unix.PtyHelpers;
import jtermios.JTermios;
import jtermios.Termios;

public class JnaPtyExecutor
implements PtyExecutor {
    private static final int STDIN_FILENO = 0;
    private static final int STDOUT_FILENO = 1;
    private static final int STDERR_FILENO = 2;

    public int execPty(String full_path, String[] argv, String[] envp, String dirpath, int[] channels, String pts_name, int fdm, boolean console) {
        int[] pipe2 = new int[2];
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        if (channels != null && console && m_jpty.pipe(pipe2) < 0) {
            return -1;
        }
        int childpid = m_jpty.fork();
        if (childpid < 0) {
            return -1;
        }
        if (childpid == 0) {
            PtyHelpers.chdir(dirpath);
            if (channels != null) {
                if (console && m_jpty.setsid() < 0) {
                    return -1;
                }
                int fds = JnaPtyExecutor.ptySlaveOpen(fdm, pts_name);
                if (fds < 0) {
                    return -1;
                }
                m_jpty.login_tty(fds);
                if (JTermios.tcsetattr((int)fds, (int)JTermios.TCSANOW, (Termios)PtyHelpers.createTermios()) != 0) {
                    return -1;
                }
                if (!console || m_jpty.close(pipe2[0]) == -1) {
                    // empty if block
                }
                m_jpty.close(fdm);
                if (console) {
                    Pty.setNoEcho(fds);
                    int pid = m_jpty.getpid();
                    if (m_jpty.setpgid(pid, pid) < 0) {
                        return -1;
                    }
                }
                m_jpty.dup2(fds, 0);
                m_jpty.dup2(fds, 1);
                if (console) {
                    m_jpty.dup2(pipe2[1], 2);
                } else {
                    m_jpty.dup2(fds, 2);
                }
                m_jpty.close(fds);
            }
            if (envp[0] == null) {
                m_jpty.execv(full_path, argv);
            } else {
                m_jpty.execve(full_path, argv, envp);
            }
            System.exit(127);
        } else if (childpid != 0) {
            if (console) {
                Pty.setNoEcho(fdm);
            }
            if (channels != null) {
                channels[0] = fdm;
                channels[1] = fdm;
                if (console) {
                    if (m_jpty.close(pipe2[1]) == -1) {
                        // empty if block
                    }
                    channels[2] = pipe2[0];
                } else {
                    channels[2] = fdm;
                }
            }
            return childpid;
        }
        return -1;
    }

    public static int ptySlaveOpen(int fdm, String pts_name) {
        int fds = JTermios.open((String)pts_name, (int)JTermios.O_RDWR);
        if (fds < 0) {
            JTermios.close((int)fdm);
            return -5;
        }
        return fds;
    }
}

