/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.ClassPathURIResolver;
import uk.ac.ed.ph.snuggletex.utilities.DefaultTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StylesheetManager {
    private TransformerFactoryChooser transformerFactoryChooser;
    private StylesheetCache stylesheetCache;

    public StylesheetManager() {
        this(DefaultTransformerFactoryChooser.getInstance(), null);
    }

    public StylesheetManager(StylesheetCache cache) {
        this(DefaultTransformerFactoryChooser.getInstance(), cache);
    }

    public StylesheetManager(TransformerFactoryChooser transformerFactoryChooser, StylesheetCache cache) {
        ConstraintUtilities.ensureNotNull(transformerFactoryChooser, "transformerFactoryChooser");
        this.transformerFactoryChooser = transformerFactoryChooser;
        this.stylesheetCache = cache;
    }

    public TransformerFactoryChooser getTransformerFactoryChooser() {
        return this.transformerFactoryChooser;
    }

    public void setTransformerFactoryChooser(TransformerFactoryChooser transformerFactoryChooser) {
        ConstraintUtilities.ensureNotNull(transformerFactoryChooser, "transformerFactoryChooser");
        this.transformerFactoryChooser = transformerFactoryChooser;
    }

    public StylesheetCache getStylesheetCache() {
        return this.stylesheetCache;
    }

    public void setStylesheetCache(StylesheetCache stylesheetCache) {
        this.stylesheetCache = stylesheetCache;
    }

    public TransformerFactory getTransformerFactory(boolean requireXSLT20) {
        this.ensureChooserSpecified();
        TransformerFactory transformerFactory = requireXSLT20 ? this.transformerFactoryChooser.getSuitableXSLT20TransformerFactory() : this.transformerFactoryChooser.getSuitableXSLT10TransformerFactory();
        transformerFactory.setURIResolver(ClassPathURIResolver.getInstance());
        return transformerFactory;
    }

    public boolean supportsXSLT20() {
        this.ensureChooserSpecified();
        return this.transformerFactoryChooser.isXSLT20SupportAvailable();
    }

    public Templates getCompiledStylesheet(String classPathUri) {
        return this.getCompiledStylesheet(classPathUri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates getCompiledStylesheet(String classPathUri, boolean requireXSLT20) {
        Templates result;
        if (this.stylesheetCache == null) {
            result = this.compileStylesheet(classPathUri, requireXSLT20);
        } else {
            StylesheetCache stylesheetCache = this.stylesheetCache;
            synchronized (stylesheetCache) {
                result = this.stylesheetCache.getStylesheet(classPathUri);
                if (result == null) {
                    result = this.compileStylesheet(classPathUri, requireXSLT20);
                    this.stylesheetCache.putStylesheet(classPathUri, result);
                }
            }
        }
        return result;
    }

    private Templates compileStylesheet(String classPathUri, boolean requireXSLT20) {
        TransformerFactory transformerFactory = this.getTransformerFactory(requireXSLT20);
        try {
            Source resolved = transformerFactory.getURIResolver().resolve(classPathUri, "");
            if (resolved == null) {
                throw new SnuggleRuntimeException("Not a ClassPath URI: " + classPathUri);
            }
            return transformerFactory.newTemplates(resolved);
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not compile internal stylesheet at " + classPathUri, e);
        }
        catch (TransformerException e) {
            throw new SnuggleRuntimeException("Could not resolve internal stylesheet location " + classPathUri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates getCompiledStylesheetDriver(List<String> importClassPathUris, boolean requireXSLT20) {
        Templates result;
        if (this.stylesheetCache == null) {
            result = this.compileStylesheetDriver(importClassPathUris, requireXSLT20);
        } else {
            String cacheKey = "xslt-driver(" + StringUtilities.join(importClassPathUris, (CharSequence)",") + ")";
            StylesheetCache stylesheetCache = this.stylesheetCache;
            synchronized (stylesheetCache) {
                result = this.stylesheetCache.getStylesheet(cacheKey);
                if (result == null) {
                    result = this.compileStylesheetDriver(importClassPathUris, requireXSLT20);
                    this.stylesheetCache.putStylesheet(cacheKey, result);
                }
            }
        }
        return result;
    }

    private Templates compileStylesheetDriver(List<String> importUris, boolean requireXSLT20) {
        TransformerFactory transformerFactory = this.getTransformerFactory(requireXSLT20);
        StringBuilder xsltBuilder = new StringBuilder("<stylesheet version='").append(requireXSLT20 ? "2.0" : "1.0").append("' xmlns='http://www.w3.org/1999/XSL/Transform'>\n");
        for (String importUri : importUris) {
            xsltBuilder.append("<import href='").append(importUri).append("'/>\n");
        }
        xsltBuilder.append("</stylesheet>");
        String xslt = xsltBuilder.toString();
        try {
            return transformerFactory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not compile stylesheet driver " + xslt, e);
        }
    }

    public Transformer getSerializer(String serializerUri, SerializationSpecifier serializationOptions) {
        Transformer serializer;
        ArrayList<String> stylesheetUris = new ArrayList<String>();
        if (serializerUri != null) {
            stylesheetUris.add(serializerUri);
        }
        boolean supportsXSLT20 = this.supportsXSLT20();
        boolean requiresXSLT20 = false;
        if (serializationOptions != null) {
            if (serializationOptions.getSerializationMethod() == SerializationMethod.HTML) {
                stylesheetUris.add("classpath:/uk/ac/ed/ph/snuggletex/strip-xhtml-namespace.xsl");
            } else if (serializationOptions.getSerializationMethod() == SerializationMethod.STRICTLY_HTML) {
                stylesheetUris.add("classpath:/uk/ac/ed/ph/snuggletex/strip-all-namespaces.xsl");
            }
            if (serializationOptions.isUsingNamedEntities() && supportsXSLT20) {
                stylesheetUris.add("classpath:/uk/ac/ed/ph/snuggletex/mathml-entities-map.xsl");
                requiresXSLT20 = true;
            }
        }
        try {
            serializer = stylesheetUris.isEmpty() ? this.getTransformerFactory(false).newTransformer() : (stylesheetUris.size() == 1 ? this.getCompiledStylesheet((String)stylesheetUris.get(0), requiresXSLT20).newTransformer() : this.getCompiledStylesheetDriver(stylesheetUris, requiresXSLT20).newTransformer());
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Unexpected failure to create serializer", e);
        }
        if (serializationOptions != null) {
            SerializationMethod serializationMethod = serializationOptions.getSerializationMethod();
            if (serializationMethod == SerializationMethod.XHTML && !supportsXSLT20) {
                serializationMethod = SerializationMethod.XML;
            }
            serializer.setOutputProperty("method", serializationMethod.getName());
            serializer.setOutputProperty("indent", StringUtilities.toYesNo(serializationOptions.isIndenting()));
            if (serializationOptions.isIndenting()) {
                XMLUtilities.setIndentation(serializer, serializationOptions.getIndent());
            }
            serializer.setOutputProperty("encoding", serializationOptions.getEncoding());
            serializer.setOutputProperty("omit-xml-declaration", StringUtilities.toYesNo(!serializationOptions.isIncludingXMLDeclaration()));
            if (serializationOptions.getDoctypePublic() != null) {
                serializer.setOutputProperty("doctype-public", serializationOptions.getDoctypePublic());
            }
            if (serializationOptions.getDoctypeSystem() != null) {
                serializer.setOutputProperty("doctype-system", serializationOptions.getDoctypeSystem());
            }
        }
        return serializer;
    }

    private void ensureChooserSpecified() {
        if (this.transformerFactoryChooser == null) {
            throw new SnuggleRuntimeException("No TransformerFactoryChooser set on this StylesheetManager");
        }
    }
}

