/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtilities {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String join(Iterable<? extends Object> objects, CharSequence separator) {
        StringBuilder result = new StringBuilder();
        Iterator<? extends Object> iter = objects.iterator();
        while (iter.hasNext()) {
            result.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(Object[] objects, CharSequence separator) {
        return StringUtilities.join(objects, separator, 0, objects.length);
    }

    public static void join(StringBuilder resultBuilder, Object[] objects, CharSequence separator) {
        StringUtilities.join(resultBuilder, objects, separator, 0, objects.length);
    }

    public static String join(Object[] objects, CharSequence separator, int startIndex, int endIndex) {
        StringBuilder result = new StringBuilder();
        StringUtilities.join(result, objects, separator, startIndex, endIndex);
        return result.toString();
    }

    public static void join(StringBuilder resultBuilder, Object[] objects, CharSequence separator, int startIndex, int endIndex) {
        boolean hasDoneFirst = false;
        for (int i = startIndex; i < endIndex; ++i) {
            if (hasDoneFirst) {
                resultBuilder.append(separator);
            }
            resultBuilder.append(objects[i].toString());
            hasDoneFirst = true;
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String nullIfEmpty(String string) {
        return StringUtilities.isNullOrEmpty(string) ? null : string;
    }

    public static String emptyIfNull(String string) {
        return string != null ? string : "";
    }

    public static String toYesNo(boolean state) {
        return state ? "yes" : "no";
    }

    public static String toTrueFalse(boolean state) {
        return state ? "true" : "false";
    }

    public static boolean fromYesNo(String value) {
        return StringUtilities.fromBinaryValues(value, "yes", "no");
    }

    public static boolean fromTrueFalse(String value) {
        return StringUtilities.fromBinaryValues(value, "true", "false");
    }

    public static boolean fromBinaryValues(String value, String trueValue, String falseValue) {
        if (value != null) {
            if (value.equals(trueValue)) {
                return true;
            }
            if (value.equals(falseValue)) {
                return false;
            }
        }
        throw new IllegalArgumentException("Argument must be " + trueValue + " or " + falseValue);
    }
}

