/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectDumper {
    public static final int DEFAULT_INDENT_WIDTH = 4;
    public static final int DEFAULT_MAX_DEPTH = 16;
    private static final String EMPTY = "(empty)";
    private final StringBuilder result;
    private int indentWidth;
    private int maxDepth;

    public ObjectDumper(StringBuilder result) {
        this.result = result;
        this.indentWidth = 4;
        this.maxDepth = 16;
    }

    public static String dumpObject(Object object, DumpMode dumpMode) {
        StringBuilder builder = new StringBuilder();
        new ObjectDumper(builder).appendObject(object, dumpMode);
        return builder.toString();
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void setIndentWidth(int indentWidth) {
        this.indentWidth = indentWidth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void appendObject(Object object) {
        DumpMode dumpMode = DumpMode.TO_STRING;
        if (object != null) {
            dumpMode = this.getElementDumpMode(object, dumpMode);
        }
        this.appendObject(object, dumpMode);
    }

    public void appendObject(Object object, DumpMode dumpMode) {
        ConstraintUtilities.ensureNotNull((Object)dumpMode, "dumpMode");
        this.appendObject(object, dumpMode, 0);
        this.result.append("\n");
    }

    private void appendObject(Object object, DumpMode dumpMode, int depth) {
        if (object != null && depth > this.maxDepth) {
            this.result.append("[Maximum graph depth exceeded by child Object of type " + object.getClass() + "]");
            return;
        }
        if (dumpMode == DumpMode.IGNORE) {
            return;
        }
        if (object == null) {
            this.result.append("null");
        } else if (object instanceof Object[]) {
            this.appendArray((Object[])object, dumpMode, depth);
        } else if (object instanceof List) {
            this.appendList((List)object, dumpMode, depth);
        } else if (object instanceof Set) {
            this.appendSet((Set)object, dumpMode, depth);
        } else if (object instanceof Map) {
            this.appendMap((Map)object, dumpMode, depth);
        } else if (object instanceof Collection) {
            this.appendCollection((Collection)object, dumpMode, depth);
        } else {
            switch (dumpMode) {
                case DEEP: {
                    this.appendObjectDeep(object, depth);
                    break;
                }
                case TO_STRING: {
                    this.result.append(object.toString());
                    break;
                }
                case IGNORE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected DumpMode " + (Object)((Object)dumpMode));
                }
            }
        }
    }

    private void appendArray(Object[] array, DumpMode dumpMode, int depth) {
        Class<?> componentType = array.getClass().getComponentType();
        this.result.append(componentType.getName()).append("[]@").append(Integer.toHexString(System.identityHashCode(array))).append("[");
        if (array.length == 0) {
            this.result.append(EMPTY);
        } else {
            this.result.append("\n");
            for (int i = 0; i < array.length; ++i) {
                this.makeIndent(depth + 1);
                this.result.append(i).append(" => ");
                this.appendObject(array[i], this.getElementDumpMode(array[i], dumpMode), depth + 1);
                this.result.append("\n");
            }
            this.makeIndent(depth);
        }
        this.result.append("]");
    }

    private <E> void appendSet(Set<E> set, DumpMode dumpMode, int depth) {
        Class<?> collectionClass = set.getClass();
        this.result.append(collectionClass.getName()).append("{");
        if (set.isEmpty()) {
            this.result.append(EMPTY);
        } else {
            this.result.append("\n");
            for (E element : set) {
                this.makeIndent(depth + 1);
                this.appendObject(element, this.getElementDumpMode(element, dumpMode), depth + 1);
                this.result.append("\n");
            }
            this.makeIndent(depth);
        }
        this.result.append("}");
    }

    private <E> void appendList(List<E> list, DumpMode dumpMode, int depth) {
        Class<?> collectionClass = list.getClass();
        this.result.append(collectionClass.getName()).append("[");
        if (list.isEmpty()) {
            this.result.append(EMPTY);
        } else {
            this.result.append("\n");
            for (int i = 0; i < list.size(); ++i) {
                E element = list.get(i);
                this.makeIndent(depth + 1);
                this.result.append(i).append(" => ");
                this.appendObject(element, this.getElementDumpMode(element, dumpMode), depth + 1);
                this.result.append("\n");
            }
            this.makeIndent(depth);
        }
        this.result.append("]");
    }

    private <E> void appendCollection(Collection<E> collection, DumpMode dumpMode, int depth) {
        Class<?> collectionClass = collection.getClass();
        this.result.append(collectionClass.getName()).append("[");
        if (collection.isEmpty()) {
            this.result.append(EMPTY);
        } else {
            this.result.append("\n");
            for (E element : collection) {
                this.makeIndent(depth + 1);
                this.appendObject(element, this.getElementDumpMode(element, dumpMode), depth + 1);
                this.result.append("\n");
            }
            this.makeIndent(depth);
        }
        this.result.append("]");
    }

    private <K, V> void appendMap(Map<K, V> map, DumpMode dumpMode, int depth) {
        Class<?> collectionClass = map.getClass();
        this.result.append(collectionClass.getName()).append("(");
        if (map.isEmpty()) {
            this.result.append(EMPTY);
        } else {
            this.result.append("\n");
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                this.makeIndent(depth + 1);
                this.result.append(key).append(" => ");
                this.appendObject(value, this.getElementDumpMode(value, dumpMode), depth + 1);
                this.result.append("\n");
            }
            this.makeIndent(depth);
        }
        this.result.append(")");
    }

    private void appendObjectDeep(Object object, int depth) {
        Method[] methods;
        Class<?> objectClass = object.getClass();
        this.result.append(objectClass.getName()).append("@").append(Integer.toHexString(object.hashCode())).append("(");
        boolean hasOutputProperty = false;
        for (Method method : methods = objectClass.getMethods()) {
            DumpMode targetDumpMode;
            String rawPropertyName;
            String methodName = method.getName();
            if (methodName.startsWith("get") && method.getParameterTypes().length == 0 && !methodName.equals("getClass") && methodName.length() > "get".length()) {
                rawPropertyName = methodName.substring("get".length());
            } else {
                if (!methodName.startsWith("is") || method.getParameterTypes().length != 0 || methodName.length() <= "is".length()) continue;
                rawPropertyName = methodName.substring("is".length());
            }
            ObjectDumperOptions annotation = method.getAnnotation(ObjectDumperOptions.class);
            DumpMode dumpMode = targetDumpMode = annotation != null ? annotation.value() : null;
            if (targetDumpMode == DumpMode.IGNORE) continue;
            if (!hasOutputProperty) {
                this.result.append("\n");
                hasOutputProperty = true;
            }
            this.makeIndent(depth + 1);
            this.result.append(Character.toLowerCase(rawPropertyName.charAt(0)));
            if (methodName.length() > 1) {
                this.result.append(rawPropertyName.substring(1));
            }
            this.result.append(" => ");
            Object value = null;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                this.result.append("[Caused Exception ").append(e).append("]");
                continue;
            }
            if (targetDumpMode == null) {
                targetDumpMode = this.getElementDumpMode(value, DumpMode.TO_STRING);
            }
            this.appendObject(value, targetDumpMode, depth + 1);
            this.result.append("\n");
        }
        if (hasOutputProperty) {
            this.makeIndent(depth);
        }
        this.result.append(")");
    }

    private DumpMode getElementDumpMode(Object object, DumpMode currentDumpMode) {
        ObjectDumperOptions annotation;
        DumpMode resultingDumpMode = currentDumpMode;
        if (object != null && (annotation = object.getClass().getAnnotation(ObjectDumperOptions.class)) != null) {
            resultingDumpMode = annotation.value();
        }
        return resultingDumpMode;
    }

    private void makeIndent(int depth) {
        for (int i = 0; i < depth * 4; ++i) {
            this.result.append(' ');
        }
    }
}

