/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.ComputedStyle;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathBracketInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.RootToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFixer {
    private final SessionContext sessionContext;

    public TokenFixer(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void fixTokenTree(RootToken rootToken) throws SnuggleParseException {
        this.visitSiblings(rootToken, rootToken.getContents());
    }

    private void visitSiblings(Token parent, List<FlowToken> content) throws SnuggleParseException {
        while (content.size() == 1 && content.get(0).getType() == TokenType.BRACE_CONTAINER) {
            List<FlowToken> innerContent = ((BraceContainerToken)content.get(0)).getContents();
            content.clear();
            content.addAll(innerContent);
        }
        switch (parent.getLatexMode()) {
            case PARAGRAPH: {
                this.visitSiblingsParagraphMode(content);
                break;
            }
            case LR: {
                this.visitSiblingsLRMode(content);
                break;
            }
            case MATH: {
                this.visitSiblingsMathMode(parent, content);
                break;
            }
            case VERBATIM: {
                break;
            }
            default: {
                throw new SnuggleLogicException("Unhandled mode " + (Object)((Object)parent.getLatexMode()));
            }
        }
    }

    private void visitToken(Token startToken) throws SnuggleParseException {
        switch (startToken.getType()) {
            case ARGUMENT_CONTAINER: {
                this.visitContainerContent((ArgumentContainerToken)startToken);
                break;
            }
            case COMMAND: {
                this.visitCommand((CommandToken)startToken);
                break;
            }
            case ENVIRONMENT: {
                this.visitEnvironment((EnvironmentToken)startToken);
                break;
            }
            case BRACE_CONTAINER: {
                BraceContainerToken braceContainer = (BraceContainerToken)startToken;
                this.visitSiblings(braceContainer, braceContainer.getContents());
                break;
            }
            case TEXT_MODE_TEXT: 
            case VERBATIM_MODE_TEXT: 
            case LR_MODE_NEW_PARAGRAPH: 
            case MATH_NUMBER: 
            case MATH_CHARACTER: 
            case ERROR: 
            case TAB_CHARACTER: {
                break;
            }
            case NEW_PARAGRAPH: {
                throw new SnuggleLogicException("Unfixed " + (Object)((Object)startToken.getType()) + " token: " + startToken);
            }
            default: {
                throw new SnuggleLogicException("Unhandled/unexpected TokenType " + (Object)((Object)startToken.getType()));
            }
        }
    }

    private void visitContainerContent(ArgumentContainerToken parent) throws SnuggleParseException {
        this.visitSiblings(parent, parent.getContents());
    }

    private void visitChildren(List<FlowToken> tokens) throws SnuggleParseException {
        for (FlowToken token : tokens) {
            this.visitToken(token);
        }
    }

    private void visitCommand(CommandToken commandToken) throws SnuggleParseException {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = commandToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitContainerContent(optArgument);
        }
        if ((arguments = commandToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitContainerContent(argument);
            }
        }
    }

    private void visitEnvironment(EnvironmentToken environmentToken) throws SnuggleParseException {
        BuiltinEnvironment environment = environmentToken.getEnvironment();
        if (environment.hasInterpretation(InterpretationType.LIST)) {
            this.fixListEnvironmentContent(environmentToken);
        } else if (environment.hasInterpretation(InterpretationType.TABULAR)) {
            this.fixTabularEnvironmentContent(environmentToken);
        }
        if (environment != CorePackageDefinitions.ENV_BRACKETED) {
            ArgumentContainerToken[] arguments;
            ArgumentContainerToken optArgument = environmentToken.getOptionalArgument();
            if (optArgument != null) {
                this.visitContainerContent(optArgument);
            }
            if ((arguments = environmentToken.getArguments()) != null) {
                for (ArgumentContainerToken argument : arguments) {
                    this.visitContainerContent(argument);
                }
            }
        }
        this.visitContainerContent(environmentToken.getContent());
    }

    private void flattenBraceContainers(List<FlowToken> tokens) {
        int index = 0;
        while (index < tokens.size()) {
            FlowToken token = tokens.get(index);
            if (token.getType() == TokenType.BRACE_CONTAINER) {
                List<FlowToken> braceContent = ((BraceContainerToken)token).getContents();
                tokens.remove(index);
                tokens.addAll(index, braceContent);
                continue;
            }
            ++index;
        }
    }

    private void visitSiblingsParagraphMode(List<FlowToken> tokens) throws SnuggleParseException {
        this.flattenBraceContainers(tokens);
        this.stripRedundantWhitespaceTokens(tokens);
        this.inferParagraphs(tokens);
        this.visitChildren(tokens);
    }

    private void stripRedundantWhitespaceTokens(List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.TEXT_MODE_TEXT) {
                boolean blockAfter;
                if ((i == 0 || i == tokens.size() - 1) && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
                boolean blockBefore = i == 0 || tokens.get(i - 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                boolean bl = blockAfter = i == tokens.size() - 1 || tokens.get(i + 1).getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK;
                if (blockBefore && blockAfter && token.getSlice().isWhitespace()) {
                    tokens.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }

    private void inferParagraphs(List<FlowToken> tokens) {
        ArrayList<FlowToken> paraContentBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        int paragraphCount = 0;
        boolean hasParagraphs = false;
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(CorePackageDefinitions.CMD_PAR)) {
                hasParagraphs = true;
                if (paraContentBuilder.isEmpty()) continue;
                resultBuilder.add(this.buildGroupedCommandToken(token, CorePackageDefinitions.CMD_PARAGRAPH, paraContentBuilder, ((FlowToken)paraContentBuilder.get(0)).getComputedStyle()));
                ++paragraphCount;
                continue;
            }
            if (token.getTextFlowContext() == TextFlowContext.START_NEW_XHTML_BLOCK) {
                hasParagraphs = true;
                if (!paraContentBuilder.isEmpty()) {
                    CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), CorePackageDefinitions.CMD_PARAGRAPH, paraContentBuilder, ((FlowToken)paraContentBuilder.get(0)).getComputedStyle());
                    resultBuilder.add(leftOver);
                    ++paragraphCount;
                }
                resultBuilder.add(token);
                continue;
            }
            if (token.getTextFlowContext() == TextFlowContext.IGNORE && paraContentBuilder.isEmpty()) {
                resultBuilder.add(token);
                continue;
            }
            paraContentBuilder.add(token);
        }
        if (!hasParagraphs) {
            return;
        }
        if (!paraContentBuilder.isEmpty()) {
            CommandToken leftOver = this.buildGroupedCommandToken(tokens.get(0), CorePackageDefinitions.CMD_PARAGRAPH, paraContentBuilder, ((FlowToken)paraContentBuilder.get(0)).getComputedStyle());
            resultBuilder.add(leftOver);
            ++paragraphCount;
        }
        tokens.clear();
        if (paragraphCount > 1) {
            tokens.addAll(resultBuilder);
        } else {
            for (FlowToken resultToken : resultBuilder) {
                if (resultToken.isCommand(CorePackageDefinitions.CMD_PARAGRAPH)) {
                    tokens.addAll(((CommandToken)resultToken).getArguments()[0].getContents());
                    continue;
                }
                tokens.add(resultToken);
            }
        }
    }

    private void visitSiblingsLRMode(List<FlowToken> tokens) throws SnuggleParseException {
        this.flattenBraceContainers(tokens);
        this.stripBlocks(tokens);
        this.visitChildren(tokens);
    }

    private void stripBlocks(List<FlowToken> tokens) throws SnuggleParseException {
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.getType() == TokenType.NEW_PARAGRAPH || token.isCommand(CorePackageDefinitions.CMD_PAR)) {
                SimpleToken replacementToken = new SimpleToken(token.getSlice(), TokenType.LR_MODE_NEW_PARAGRAPH, LaTeXMode.LR, TextFlowContext.ALLOW_INLINE, new Interpretation[0]);
                this.replaceToken(tokens, i, replacementToken);
                continue;
            }
            if (token.getType() == TokenType.ERROR || token.getTextFlowContext() != TextFlowContext.START_NEW_XHTML_BLOCK) continue;
            this.replaceToken(tokens, i, this.createError(token, CoreErrorCode.TFEG00, token.getSlice().extract().toString()));
        }
    }

    private void fixListEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        List<FlowToken> contents = environmentToken.getContent().getContents();
        ArrayList<FlowToken> itemBuilder = new ArrayList<FlowToken>();
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        Token lastItemToken = null;
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            FlowToken token = contents.get(i);
            if (token.isCommand(CorePackageDefinitions.CMD_ITEM)) {
                if (lastItemToken != null) {
                    CommandToken itemBefore = this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_LIST_ITEM, itemBuilder, lastItemToken.getComputedStyle());
                    resultBuilder.add(itemBefore);
                }
                lastItemToken = (CommandToken)token;
                continue;
            }
            if (lastItemToken == null) {
                if (token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace() || token.getType() == TokenType.NEW_PARAGRAPH) continue;
                resultBuilder.add(this.createError(token, CoreErrorCode.TFEL00, new Object[0]));
                continue;
            }
            itemBuilder.add(token);
        }
        if (lastItemToken != null) {
            resultBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_LIST_ITEM, itemBuilder, lastItemToken.getComputedStyle()));
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void fixTabularEnvironmentContent(EnvironmentToken environmentToken) throws SnuggleParseException {
        ArrayList<FlowToken> resultBuilder = new ArrayList<FlowToken>();
        ArrayList<CommandToken> rowBuilder = new ArrayList<CommandToken>();
        ArrayList<FlowToken> columnBuilder = new ArrayList<FlowToken>();
        List<FlowToken> contents = environmentToken.getContent().getContents();
        List<FlowToken> entries = contents;
        if (entries.size() > 0 && !entries.get(entries.size() - 1).isCommand(CorePackageDefinitions.CMD_CHAR_BACKSLASH)) {
            entries = new ArrayList<FlowToken>(entries);
            entries.add(null);
        }
        Token lastGoodToken = null;
        ComputedStyle columnStartStyle = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FlowToken token = entries.get(i);
            if (columnStartStyle == null) {
                if (token != null) {
                    columnStartStyle = token.getComputedStyle();
                } else {
                    ComputedStyle computedStyle = columnStartStyle = i > 0 ? entries.get(0).getComputedStyle() : environmentToken.getComputedStyle();
                }
            }
            if (token == null || token.isCommand(CorePackageDefinitions.CMD_CHAR_BACKSLASH)) {
                if (token == null && lastGoodToken != null && lastGoodToken.isCommand(CorePackageDefinitions.CMD_HLINE)) break;
                rowBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_COLUMN, columnBuilder, columnStartStyle));
                resultBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_ROW, rowBuilder, ((CommandToken)rowBuilder.get(0)).getComputedStyle()));
            } else {
                if (token.getType() == TokenType.TEXT_MODE_TEXT && token.getSlice().isWhitespace()) continue;
                if (token.getType() == TokenType.TAB_CHARACTER) {
                    rowBuilder.add(this.buildGroupedCommandToken(environmentToken, CorePackageDefinitions.CMD_TABLE_COLUMN, columnBuilder, columnStartStyle));
                    columnStartStyle = null;
                } else if (token.isCommand(CorePackageDefinitions.CMD_HLINE)) {
                    if (!columnBuilder.isEmpty()) {
                        resultBuilder.add(this.createError((FlowToken)columnBuilder.get(0), CoreErrorCode.TFETB0, new Object[0]));
                        columnBuilder.clear();
                    } else if (!rowBuilder.isEmpty()) {
                        resultBuilder.add(this.createError((FlowToken)rowBuilder.get(0), CoreErrorCode.TFETB0, new Object[0]));
                        rowBuilder.clear();
                    }
                    resultBuilder.add(token);
                } else {
                    columnBuilder.add(token);
                }
            }
            lastGoodToken = token;
        }
        contents.clear();
        contents.addAll(resultBuilder);
    }

    private void visitSiblingsMathMode(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        BuiltinCommand command;
        if (tokens.isEmpty()) {
            return;
        }
        boolean isStructural = false;
        FlowToken firstToken = tokens.get(0);
        if (firstToken.getType() == TokenType.COMMAND && ((command = ((CommandToken)firstToken).getCommand()) == CorePackageDefinitions.CMD_TABLE_ROW || command == CorePackageDefinitions.CMD_TABLE_COLUMN)) {
            isStructural = true;
        }
        if (!isStructural) {
            this.fixLeadingNegativeNumber(tokens);
            this.fencePairedParentheses(parentToken, tokens);
            this.fixOverInstances(parentToken, tokens);
            this.fixChooseInstances(parentToken, tokens);
            this.inferParenthesisFences(parentToken, tokens);
            this.fixSubscriptAndSuperscripts(parentToken, tokens);
            this.fixPrimes(tokens);
        }
        this.visitChildren(tokens);
    }

    private void fixLeadingNegativeNumber(List<FlowToken> tokens) {
        if (tokens.size() < 2) {
            return;
        }
        FlowToken firstToken = tokens.get(0);
        FlowToken secondToken = tokens.get(1);
        if (firstToken.getMathCharacterCodePoint() == 45 && secondToken.hasInterpretationType(InterpretationType.MATH_NUMBER)) {
            String negation = "-" + ((MathNumberInterpretation)secondToken.getInterpretation(InterpretationType.MATH_NUMBER)).getNumber();
            SimpleToken replacementToken = new SimpleToken(firstToken.getSlice().rightOuterSpan(secondToken.getSlice()), TokenType.MATH_NUMBER, firstToken.getLatexMode(), null, new Interpretation[]{new MathNumberInterpretation(negation)});
            this.replaceTokens(tokens, 0, 2, replacementToken);
        }
    }

    private void fixOverInstances(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        int overIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (!token.isCommand(CorePackageDefinitions.CMD_OVER)) continue;
            if (overIndex != -1) {
                tokens.clear();
                tokens.add(this.createError(token, CoreErrorCode.TFEM00, new Object[0]));
                return;
            }
            overIndex = i;
        }
        if (overIndex != -1) {
            ArrayList<FlowToken> beforeTokens = new ArrayList<FlowToken>(tokens.subList(0, overIndex));
            ArrayList<FlowToken> afterTokens = new ArrayList<FlowToken>(tokens.subList(overIndex + 1, tokens.size()));
            ComputedStyle beforeStyle = tokens.get(0).getComputedStyle();
            CommandToken replacementToken = new CommandToken(parentToken.getSlice(), LaTeXMode.MATH, CorePackageDefinitions.CMD_FRAC, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, beforeTokens, beforeStyle), ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, afterTokens, beforeStyle)});
            this.replaceTokens(tokens, 0, tokens.size(), replacementToken);
        }
    }

    private void fixChooseInstances(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        int index = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (!token.isCommand(CorePackageDefinitions.CMD_CHOOSE)) continue;
            if (index != -1) {
                tokens.clear();
                return;
            }
            index = i;
        }
        if (index != -1) {
            ArrayList<FlowToken> beforeTokens = new ArrayList<FlowToken>(tokens.subList(0, index));
            ArrayList<FlowToken> afterTokens = new ArrayList<FlowToken>(tokens.subList(index + 1, tokens.size()));
            ComputedStyle beforeStyle = tokens.get(0).getComputedStyle();
            CommandToken replacementToken = new CommandToken(parentToken.getSlice(), LaTeXMode.MATH, CorePackageDefinitions.CMD_BINOM, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, beforeTokens, beforeStyle), ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, afterTokens, beforeStyle)});
            this.replaceTokens(tokens, 0, tokens.size(), replacementToken);
        }
    }

    private void fixPrimes(List<FlowToken> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            FlowToken maybePrimeToken = tokens.get(i + 1);
            if (maybePrimeToken.getMathCharacterCodePoint() != 39) continue;
            FlowToken leftToken = tokens.get(i);
            FrozenSlice replacementSlice = leftToken.getSlice().rightOuterSpan(maybePrimeToken.getSlice());
            CommandToken replacementToken = new CommandToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.CMD_MSUP_OR_MOVER, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, leftToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, maybePrimeToken)});
            this.replaceTokens(tokens, i, i + 2, replacementToken);
        }
    }

    private void fixSubscriptAndSuperscripts(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        for (int i = 0; i < tokens.size(); ++i) {
            CommandToken replacementToken;
            BuiltinCommand replacementCommand;
            FrozenSlice replacementSlice;
            int followingCodePoint;
            int startModifyIndex;
            ArgumentContainerToken t1Result;
            FlowToken t1;
            int size = tokens.size();
            FlowToken token = tokens.get(i);
            boolean firstIsSuper = false;
            boolean isSubOrSuper = false;
            int tokenCodePoint = token.getMathCharacterCodePoint();
            firstIsSuper = tokenCodePoint == 94;
            boolean bl = isSubOrSuper = firstIsSuper || tokenCodePoint == 95;
            if (!isSubOrSuper) continue;
            if (i == size - 1) {
                this.replaceToken(tokens, i, this.createError(token, CoreErrorCode.TFEM01, new Object[0]));
                continue;
            }
            if (i == 0) {
                t1 = token;
                t1Result = ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH, tokens.get(0).getComputedStyle());
                startModifyIndex = i;
            } else {
                t1 = tokens.get(i - 1);
                t1Result = ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t1);
                startModifyIndex = i - 1;
            }
            FlowToken t2 = tokens.get(i + 1);
            ArgumentContainerToken t2Result = ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, t2);
            Token t3 = null;
            ArgumentContainerToken t3Result = null;
            if (i + 2 < size && ((followingCodePoint = tokens.get(i + 2).getMathCharacterCodePoint()) == 95 || followingCodePoint == 94)) {
                if (i + 3 >= size) {
                    this.replaceTokens(tokens, startModifyIndex, i + 3, this.createError(token, CoreErrorCode.TFEM01, new Object[0]));
                    continue;
                }
                t3 = tokens.get(i + 3);
                t3Result = ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)t3);
                if (tokenCodePoint == 94 && followingCodePoint == 94 || tokenCodePoint == 95 && followingCodePoint == 95) {
                    this.replaceTokens(tokens, startModifyIndex, i + 3, this.createError(token, CoreErrorCode.TFEM02, new Object[0]));
                    continue;
                }
            }
            if (t3 != null) {
                replacementSlice = t1.getSlice().rightOuterSpan(t3.getSlice());
                replacementCommand = CorePackageDefinitions.CMD_MSUBSUP_OR_MUNDEROVER;
                replacementToken = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{t1Result, firstIsSuper ? t3Result : t2Result, firstIsSuper ? t2Result : t3Result});
                this.replaceTokens(tokens, startModifyIndex, i + 4, replacementToken);
                continue;
            }
            replacementSlice = t1.getSlice().rightOuterSpan(t2.getSlice());
            replacementCommand = firstIsSuper ? CorePackageDefinitions.CMD_MSUP_OR_MOVER : CorePackageDefinitions.CMD_MSUB_OR_MUNDER;
            replacementToken = new CommandToken(replacementSlice, LaTeXMode.MATH, replacementCommand, null, new ArgumentContainerToken[]{t1Result, t2Result});
            this.replaceTokens(tokens, startModifyIndex, i + 2, replacementToken);
        }
    }

    private void fencePairedParentheses(Token parentToken, List<FlowToken> tokens) throws SnuggleParseException {
        for (int i = 0; i < tokens.size(); ++i) {
            FlowToken token = tokens.get(i);
            if (token.isCommand(CorePackageDefinitions.CMD_RIGHT)) {
                this.replaceToken(tokens, i, this.createError(token, CoreErrorCode.TFEM03, new Object[0]));
                continue;
            }
            if (!token.isCommand(CorePackageDefinitions.CMD_LEFT)) continue;
            ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
            CommandToken openBracketToken = (CommandToken)token;
            Token matchingCloseBracketToken = null;
            int matchingCloseBracketIndex = -1;
            int bracketLevel = 1;
            for (int j = i + 1; j < tokens.size(); ++j) {
                FlowToken innerToken = tokens.get(j);
                if (innerToken.isCommand(CorePackageDefinitions.CMD_LEFT)) {
                    ++bracketLevel;
                } else if (innerToken.isCommand(CorePackageDefinitions.CMD_RIGHT) && --bracketLevel == 0) {
                    matchingCloseBracketToken = (CommandToken)innerToken;
                    matchingCloseBracketIndex = j;
                    break;
                }
                innerTokens.add(innerToken);
            }
            if (matchingCloseBracketToken == null) {
                this.replaceTokens(tokens, i, tokens.size(), this.createError(token, CoreErrorCode.TFEM04, new Object[0]));
                break;
            }
            FrozenSlice replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
            EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, openBracketToken.getCombinerTarget().getContents(), openBracketToken.getComputedStyle()), ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, ((CommandToken)matchingCloseBracketToken).getCombinerTarget().getContents(), matchingCloseBracketToken.getComputedStyle())}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens, openBracketToken.getComputedStyle()));
            this.replaceTokens(tokens, i, matchingCloseBracketIndex + 1, replacementToken);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inferParenthesisFences(Token parentToken, List<FlowToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            MathBracketInterpretation interpretation;
            FlowToken token = tokens.get(i);
            if (token.hasInterpretationType(InterpretationType.MATH_BRACKET) && (interpretation = (MathBracketInterpretation)token.getInterpretation(InterpretationType.MATH_BRACKET)).isPairingInferencePossible()) {
                MathBracketInterpretation.BracketType bracketType = interpretation.getBracketType();
                if (bracketType == MathBracketInterpretation.BracketType.CLOSER) {
                    FrozenSlice replacementSlice = tokens.get(0).getSlice().rightOuterSpan(token.getSlice());
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>(tokens.subList(0, i));
                    EnvironmentToken replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH, tokens.get(0).getComputedStyle()), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, token)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens, tokens.get(0).getComputedStyle()));
                    this.replaceTokens(tokens, 0, i + 1, replacementToken);
                    i = 0;
                } else if (bracketType != MathBracketInterpretation.BracketType.OPENER_OR_CLOSER) {
                    EnvironmentToken replacementToken;
                    FrozenSlice replacementSlice;
                    ArrayList<FlowToken> innerTokens = new ArrayList<FlowToken>();
                    FlowToken openBracketToken = token;
                    Token matchingCloseBracketToken = null;
                    int matchingCloseBracketIndex = -1;
                    Stack<MathBracketInterpretation> openerStack = new Stack<MathBracketInterpretation>();
                    openerStack.add(interpretation);
                    block6: for (int j = i + 1; j < tokens.size(); ++j) {
                        FlowToken afterToken = tokens.get(j);
                        if (afterToken.hasInterpretationType(InterpretationType.MATH_BRACKET)) {
                            MathBracketInterpretation afterInterpretation = (MathBracketInterpretation)afterToken.getInterpretation(InterpretationType.MATH_BRACKET);
                            MathBracketInterpretation.BracketType afterBracketType = afterInterpretation.getBracketType();
                            switch (afterBracketType) {
                                case OPENER: {
                                    openerStack.add(afterInterpretation);
                                    break;
                                }
                                case OPENER_OR_CLOSER: {
                                    break;
                                }
                                case CLOSER: {
                                    openerStack.pop();
                                    if (!openerStack.isEmpty()) break;
                                    matchingCloseBracketToken = afterToken;
                                    matchingCloseBracketIndex = j;
                                    break block6;
                                }
                            }
                        }
                        innerTokens.add(afterToken);
                    }
                    if (matchingCloseBracketToken != null) {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(matchingCloseBracketToken.getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, (FlowToken)matchingCloseBracketToken)}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens, openBracketToken.getComputedStyle()));
                        this.replaceTokens(tokens, i, matchingCloseBracketIndex + 1, replacementToken);
                    } else {
                        replacementSlice = openBracketToken.getSlice().rightOuterSpan(tokens.get(tokens.size() - 1).getSlice());
                        replacementToken = new EnvironmentToken(replacementSlice, LaTeXMode.MATH, CorePackageDefinitions.ENV_BRACKETED, null, new ArgumentContainerToken[]{ArgumentContainerToken.createFromSingleToken(LaTeXMode.MATH, openBracketToken), ArgumentContainerToken.createEmptyContainer(parentToken, LaTeXMode.MATH, openBracketToken.getComputedStyle())}, ArgumentContainerToken.createFromContiguousTokens(parentToken, LaTeXMode.MATH, innerTokens, openBracketToken.getComputedStyle()));
                        this.replaceTokens(tokens, i, tokens.size(), replacementToken);
                    }
                }
            }
            ++i;
        }
        return;
    }

    private void replaceToken(List<FlowToken> tokens, int index, FlowToken replacementToken) {
        replacementToken.setComputedStyle(tokens.get(index).getComputedStyle());
        tokens.set(index, replacementToken);
    }

    private void replaceTokens(List<FlowToken> tokens, int startIndex, int endIndex, FlowToken replacementToken) {
        this.replaceToken(tokens, startIndex, replacementToken);
        if (endIndex > startIndex + 1) {
            tokens.subList(startIndex + 1, endIndex).clear();
        }
    }

    private CommandToken buildGroupedCommandToken(Token parentToken, BuiltinCommand command, List<? extends FlowToken> itemBuilder, ComputedStyle computedStyle) {
        ArgumentContainerToken contentToken = itemBuilder.isEmpty() ? ArgumentContainerToken.createEmptyContainer(parentToken, parentToken.getLatexMode(), computedStyle) : ArgumentContainerToken.createFromContiguousTokens(parentToken, itemBuilder.get(0).getLatexMode(), itemBuilder, computedStyle);
        CommandToken result = new CommandToken(contentToken.getSlice(), contentToken.getLatexMode(), command, null, new ArgumentContainerToken[]{contentToken});
        result.setComputedStyle(computedStyle);
        itemBuilder.clear();
        return result;
    }

    private ErrorToken createError(FlowToken token, CoreErrorCode errorCode, Object ... arguments) throws SnuggleParseException {
        FrozenSlice slice = token.getSlice();
        InputError error = new InputError(errorCode, slice, arguments);
        this.sessionContext.registerError(error);
        ErrorToken result = new ErrorToken(error, token.getLatexMode());
        result.setComputedStyle(token.getComputedStyle());
        return result;
    }
}

