/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.List;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.ComputedStyle;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.StyleDeclarationInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.RootToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyleEvaluator {
    private final SessionContext sessionContext;

    public StyleEvaluator(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void evaluateStyles(RootToken rootToken) throws SnuggleParseException {
        rootToken.setComputedStyle(ComputedStyle.DEFAULT_STYLE);
        this.visitSiblings(rootToken.getContents(), ComputedStyle.DEFAULT_STYLE);
    }

    private void visitSiblings(List<FlowToken> content, ComputedStyle scopeStyle) throws SnuggleParseException {
        ComputedStyle currentStyle = scopeStyle;
        int index = 0;
        while (index < content.size()) {
            FlowToken token = content.get(index);
            if (token.hasInterpretationType(InterpretationType.STYLE_DECLARATION)) {
                ComputedStyle newStyle = this.mergeStyle(currentStyle, (StyleDeclarationInterpretation)token.getInterpretation(InterpretationType.STYLE_DECLARATION));
                if (token instanceof CommandToken) {
                    CommandToken commandToken = (CommandToken)token;
                    if (commandToken.getCommand().getArgumentCount() == 0) {
                        currentStyle = newStyle;
                        content.remove(index);
                        continue;
                    }
                    ArgumentContainerToken styleContentToken = commandToken.getArguments()[0];
                    this.visitContainerContent(styleContentToken, newStyle);
                    content.remove(index);
                    content.addAll(index, styleContentToken.getContents());
                    index += styleContentToken.getContents().size();
                    continue;
                }
                if (token instanceof EnvironmentToken) {
                    ArgumentContainerToken styleContentToken = ((EnvironmentToken)token).getContent();
                    this.visitContainerContent(styleContentToken, newStyle);
                    content.remove(index);
                    content.addAll(index, styleContentToken.getContents());
                    index += styleContentToken.getContents().size();
                    continue;
                }
                throw new SnuggleLogicException("Unexpected logic branch");
            }
            token.setComputedStyle(currentStyle);
            switch (token.getType()) {
                case COMMAND: {
                    this.visitCommand((CommandToken)token, currentStyle);
                    break;
                }
                case ENVIRONMENT: {
                    this.visitEnvironment((EnvironmentToken)token, currentStyle);
                    break;
                }
                case BRACE_CONTAINER: {
                    BraceContainerToken braceToken = (BraceContainerToken)token;
                    this.visitSiblings(braceToken.getContents(), this.newStyleScope(currentStyle));
                    break;
                }
                case TEXT_MODE_TEXT: 
                case VERBATIM_MODE_TEXT: 
                case LR_MODE_NEW_PARAGRAPH: 
                case MATH_NUMBER: 
                case MATH_CHARACTER: 
                case ERROR: 
                case TAB_CHARACTER: 
                case NEW_PARAGRAPH: {
                    break;
                }
                default: {
                    throw new SnuggleLogicException("Unhandled/unexpected TokenType " + (Object)((Object)token.getType()));
                }
            }
            ++index;
        }
    }

    private void visitContainerContent(ArgumentContainerToken parent, ComputedStyle scopeStyle) throws SnuggleParseException {
        parent.setComputedStyle(scopeStyle);
        this.visitSiblings(parent.getContents(), scopeStyle);
    }

    private void visitCommand(CommandToken commandToken, ComputedStyle currentStyle) throws SnuggleParseException {
        ArgumentContainerToken combinerTarget;
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = commandToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitContainerContent(optArgument, currentStyle);
        }
        if ((arguments = commandToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitContainerContent(argument, currentStyle);
            }
        }
        if ((combinerTarget = commandToken.getCombinerTarget()) != null) {
            this.visitContainerContent(combinerTarget, currentStyle);
        }
    }

    private void visitEnvironment(EnvironmentToken environmentToken, ComputedStyle currentStyle) throws SnuggleParseException {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = environmentToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitContainerContent(optArgument, currentStyle);
        }
        if ((arguments = environmentToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitContainerContent(argument, currentStyle);
            }
        }
        ComputedStyle contentStyle = currentStyle;
        if (environmentToken.getEnvironment().getContentMode() == LaTeXMode.MATH && environmentToken.getLatexMode() != LaTeXMode.MATH) {
            contentStyle = new ComputedStyle(contentStyle, ComputedStyle.FontFamily.NORMAL, contentStyle.getFontSize());
        }
        this.visitContainerContent(environmentToken.getContent(), contentStyle);
    }

    private ComputedStyle newStyleScope(ComputedStyle currentStyle) {
        if (currentStyle == null) {
            throw new SnuggleLogicException("currentStyle should not be null");
        }
        return new ComputedStyle(currentStyle, currentStyle.getFontFamily(), currentStyle.getFontSize());
    }

    private ComputedStyle mergeStyle(ComputedStyle currentStyle, StyleDeclarationInterpretation interpretation) {
        ComputedStyle.FontFamily newFontFamily = interpretation.getFontFamily();
        ComputedStyle.FontSize newFontSize = interpretation.getFontSize();
        return new ComputedStyle(currentStyle, newFontFamily != null ? newFontFamily : currentStyle.getFontFamily(), newFontSize != null ? newFontSize : currentStyle.getFontSize());
    }
}

