/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class VerbatimHandler
implements CommandHandler,
EnvironmentHandler {
    private final boolean starred;

    public VerbatimHandler(boolean starred) {
        this.starred = starred;
    }

    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) {
        ArgumentContainerToken argumentToken = token.getArguments()[0];
        String verbContent = argumentToken.getSlice().extract().toString();
        verbContent = this.starred ? verbContent.replace(' ', '\u2423') : verbContent.replace(' ', '\u00a0');
        Element verbatimElement = builder.appendXHTMLElement(parentElement, "span");
        verbatimElement.setAttribute("class", "verb");
        builder.appendTextNode(verbatimElement, verbContent, false);
        this.appendEmbeddedErrors(builder, parentElement, argumentToken);
    }

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) {
        String verbatimContent = token.getContent().getSlice().extract().toString();
        Element verbatimElement = builder.appendXHTMLElement(parentElement, "pre");
        verbatimElement.setAttribute("class", "verbatim");
        builder.appendTextNode(verbatimElement, verbatimContent, false);
        this.appendEmbeddedErrors(builder, parentElement, token.getContent());
    }

    private void appendEmbeddedErrors(DOMBuilder builder, Element parentElement, ArgumentContainerToken content) {
        for (FlowToken flowToken : content.getContents()) {
            if (flowToken.getType() != TokenType.ERROR) continue;
            builder.appendErrorElement(parentElement, (ErrorToken)flowToken);
        }
    }
}

