/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class TabularHandler
implements CommandHandler,
EnvironmentHandler {
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        builder.appendOrThrowError(parentElement, token, CoreErrorCode.TDETB3, token.getCommand().getTeXName());
    }

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        int numColumns = geometry[1];
        ArrayList columnClasses = new ArrayList();
        ArgumentContainerToken specToken = token.getArguments()[0];
        CharSequence specData = token.getArguments()[0].getSlice().extract();
        String cellAlign = null;
        boolean borderFlag = false;
        for (int i = 0; i < specData.length(); ++i) {
            char c = specData.charAt(i);
            if (Character.isWhitespace(c)) continue;
            switch (c) {
                case 'c': {
                    cellAlign = "align-center";
                    break;
                }
                case 'l': {
                    cellAlign = "align-left";
                    break;
                }
                case 'r': {
                    cellAlign = "align-right";
                    break;
                }
                case '|': {
                    borderFlag = true;
                    break;
                }
                default: {
                    builder.appendOrThrowError(parentElement, specToken, CoreErrorCode.TDETB1, String.valueOf(c));
                }
            }
            if (cellAlign == null) continue;
            ArrayList<String> classes = new ArrayList<String>();
            classes.add(cellAlign);
            if (borderFlag) {
                classes.add("left-border");
            }
            columnClasses.add(classes);
            cellAlign = null;
            borderFlag = false;
        }
        if (columnClasses.isEmpty()) {
            builder.appendOrThrowError(parentElement, specToken, CoreErrorCode.TDETB2, new Object[0]);
            return;
        }
        if (borderFlag) {
            ((List)columnClasses.get(columnClasses.size() - 1)).add("right-border");
        }
        if (columnClasses.size() < numColumns) {
            builder.appendOrThrowError(parentElement, specToken, CoreErrorCode.TDETB0, columnClasses.size(), numColumns);
        }
        Element tableElement = builder.appendXHTMLElement(parentElement, "table");
        builder.applyCSSStyle(tableElement, "tabular");
        Element tbodyElement = builder.appendXHTMLElement(tableElement, "tbody");
        ArrayList<String> tdClasses = new ArrayList<String>(3);
        List<FlowToken> tableContents = token.getContent().getContents();
        boolean topBorderFlag = false;
        boolean bottomBorderFlag = false;
        for (int rowIndex = 0; rowIndex < tableContents.size(); ++rowIndex) {
            Element tdElement;
            Element trElement;
            FlowToken rowToken = tableContents.get(rowIndex);
            if (rowToken.isCommand(CorePackageDefinitions.CMD_HLINE)) {
                topBorderFlag = true;
                continue;
            }
            if (rowToken.isCommand(CorePackageDefinitions.CMD_TABLE_ROW)) {
                bottomBorderFlag = false;
                for (int i = rowIndex + 1; i < tableContents.size(); ++i) {
                    if (!tableContents.get(i).isCommand(CorePackageDefinitions.CMD_HLINE)) {
                        bottomBorderFlag = false;
                        break;
                    }
                    bottomBorderFlag = true;
                }
                List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
                trElement = builder.appendXHTMLElement(tbodyElement, "tr");
                int columnsInRow = columns.size();
                for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
                    tdElement = builder.appendXHTMLElement(trElement, "td");
                    tdClasses.clear();
                    tdClasses.add("tabular");
                    if (columnIndex < columnClasses.size()) {
                        tdClasses.addAll((Collection)columnClasses.get(columnIndex));
                    }
                    if (topBorderFlag) {
                        tdClasses.add("top-border");
                    }
                    if (bottomBorderFlag) {
                        tdClasses.add("bottom-border");
                    }
                    builder.applyCSSStyle(tdElement, tdClasses.toArray(new String[tdClasses.size()]));
                    if (columnIndex >= columnsInRow) continue;
                    builder.handleTokens(tdElement, ((CommandToken)columns.get(columnIndex)).getArguments()[0].getContents(), true);
                }
                topBorderFlag = false;
                if (!bottomBorderFlag) continue;
                break;
            }
            if (rowToken.getType() == TokenType.ERROR) {
                trElement = builder.appendXHTMLElement(tbodyElement, "tr");
                tdElement = builder.appendXHTMLElement(trElement, "td");
                builder.appendErrorElement(tdElement, (ErrorToken)rowToken);
                continue;
            }
            throw new SnuggleLogicException("Expected table contents to be \\hline or table rows");
        }
    }

    protected static int[] computeTableDimensions(ArgumentContainerToken tableContent) {
        int maxColumns = 0;
        int rowCount = 0;
        int colCountWithinRow = 0;
        for (FlowToken contentToken : tableContent) {
            if (contentToken.isCommand(CorePackageDefinitions.CMD_HLINE) || contentToken.getType() == TokenType.ERROR) continue;
            if (contentToken.isCommand(CorePackageDefinitions.CMD_TABLE_ROW)) {
                ++rowCount;
                colCountWithinRow = 0;
                CommandToken rowToken = (CommandToken)contentToken;
                ArgumentContainerToken rowContents = rowToken.getArguments()[0];
                for (FlowToken rowContentToken : rowContents) {
                    if (rowContentToken.isCommand(CorePackageDefinitions.CMD_TABLE_COLUMN)) {
                        ++colCountWithinRow;
                        continue;
                    }
                    throw new SnuggleLogicException("Did not expect to find token " + rowContentToken + " within a table row");
                }
                if (colCountWithinRow <= maxColumns) continue;
                maxColumns = colCountWithinRow;
                continue;
            }
            throw new SnuggleLogicException("Did not expect to find token " + contentToken + " within a top-level table content");
        }
        return new int[]{rowCount, maxColumns};
    }
}

