/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class MathLimitsHandler
implements CommandHandler {
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        String elementName;
        List<FlowToken> limitand = token.getArguments()[0].getContents();
        boolean isUnderOver = builder.getOutputContext() == DOMBuilder.OutputContext.MATHML_BLOCK && limitand.size() == 1 && limitand.get(0).hasInterpretationType(InterpretationType.MATH_BIG_LIMIT_OWNER);
        BuiltinCommand command = token.getCommand();
        if (command.equals(CorePackageDefinitions.CMD_MSUB_OR_MUNDER)) {
            elementName = isUnderOver ? "munder" : "msub";
        } else if (command.equals(CorePackageDefinitions.CMD_MSUP_OR_MOVER)) {
            elementName = isUnderOver ? "mover" : "msup";
        } else if (command.equals(CorePackageDefinitions.CMD_MSUBSUP_OR_MUNDEROVER)) {
            elementName = isUnderOver ? "munderover" : "msubsup";
        } else {
            throw new SnuggleLogicException("Unexpected limit command " + command);
        }
        Element result = builder.appendMathMLElement(parentElement, elementName);
        for (ArgumentContainerToken argument : token.getArguments()) {
            builder.handleMathTokensAsSingleElement(result, argument);
        }
    }
}

