/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.TabularHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class AlignHandler
implements EnvironmentHandler {
    static final String[] COLUMN_ALIGNMENTS = new String[]{"right", "center", "left"};

    public void handleEnvironment(final DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        final int numColumns = geometry[1];
        if (numColumns > 3) {
            builder.appendOrThrowError(parentElement, token, CoreErrorCode.TDEM01, numColumns);
            return;
        }
        DOMBuilder.MathContentBuilderCallback callback = new DOMBuilder.MathContentBuilderCallback(){

            public void buildMathElementContent(Element contentContainerElement, ArgumentContainerToken mathContentToken, boolean isAnnotated) throws SnuggleParseException {
                Element mtableElement = builder.appendMathMLElement(contentContainerElement, "mtable");
                for (FlowToken rowToken : mathContentToken) {
                    Element mtrElement = builder.appendMathMLElement(mtableElement, "mtr");
                    List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
                    int columnIndex = 0;
                    for (FlowToken columnToken : columns) {
                        Element mtdElement = builder.appendMathMLElement(mtrElement, "mtd");
                        mtdElement.setAttribute("columnalign", COLUMN_ALIGNMENTS[columnIndex++]);
                        builder.handleTokens(mtdElement, ((CommandToken)columnToken).getArguments()[0].getContents(), true);
                    }
                    for (int i = 0; i < numColumns - columns.size(); ++i) {
                        builder.appendMathMLElement(mtrElement, "mtd");
                    }
                }
            }
        };
        builder.buildMathElement(parentElement, token, token.getContent(), true, callback);
    }
}

