/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.AccentMap;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.MathCharacter;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class AccentHandler
implements CommandHandler {
    private final AccentMap accentMap;
    private final char combiningCharacter;
    private final String mathMLElementName;

    public AccentHandler(AccentMap accentMap, char combiningCharacter, String mathMLElementName) {
        this.accentMap = accentMap;
        this.combiningCharacter = combiningCharacter;
        this.mathMLElementName = mathMLElementName;
    }

    public AccentHandler(AccentMap accentMap) {
        this(accentMap, '\u0000', null);
    }

    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        if (builder.isBuildingMathMLIsland()) {
            if (this.mathMLElementName == null) {
                throw new SnuggleLogicException("Unexpected logic branch - unexpected accent found in MATH mode");
            }
            this.handleCommandMathMode(builder, parentElement, token);
        } else {
            this.handleCommandTextMode(builder, parentElement, token);
        }
    }

    public void handleCommandMathMode(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        List<FlowToken> content = token.getArguments()[0].getContents();
        char mathAccent = '\u0000';
        if (this.accentMap != null && content.size() == 1 && content.get(0).hasInterpretationType(InterpretationType.MATH_CHARACTER)) {
            MathCharacter mathCharacter = content.get(0).getMathCharacter();
            mathAccent = this.accentMap.getAccentedMathChar(mathCharacter.getCodePoint());
        }
        if (mathAccent != '\u0000') {
            builder.appendMathMLIdentifierElement(parentElement, Character.toString(mathAccent));
        } else {
            Element result = builder.appendMathMLElement(parentElement, this.mathMLElementName);
            if (this.mathMLElementName.equals("mover")) {
                result.setAttribute("accent", "true");
            } else if (this.mathMLElementName.equals("munder")) {
                result.setAttribute("accentunder", "true");
            }
            builder.handleMathTokensAsSingleElement(result, content);
            builder.appendMathMLOperatorElement(result, Character.toString(this.combiningCharacter));
        }
    }

    public void handleCommandTextMode(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        CharSequence textContent;
        List<FlowToken> contents = token.getArguments()[0].getContents();
        if (contents.size() == 1 && contents.get(0).getType() != TokenType.TEXT_MODE_TEXT) {
            builder.appendOrThrowError(parentElement, token, CoreErrorCode.TDETA0, new Object[0]);
            return;
        }
        CharSequence charSequence = textContent = contents.isEmpty() ? null : contents.get(0).getSlice().extract();
        if (textContent == null || textContent.length() == 0) {
            builder.appendOrThrowError(parentElement, token, CoreErrorCode.TDETA1, new Object[0]);
            return;
        }
        char firstChar = textContent.charAt(0);
        char accentedFirstChar = this.accentMap.getAccentedTextChar(firstChar);
        if (accentedFirstChar != '\u0000') {
            String replacedContent = accentedFirstChar + textContent.subSequence(1, textContent.length()).toString();
            builder.appendTextNode(parentElement, replacedContent, false);
        } else {
            builder.appendOrThrowError(parentElement, token, CoreErrorCode.TDETA2, Character.toString(firstChar));
        }
    }
}

