/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;

@ObjectDumperOptions(value=DumpMode.TO_STRING)
public final class ComputedStyle {
    public static final ComputedStyle DEFAULT_STYLE = new ComputedStyle(null, FontFamily.NORMAL, FontSize.NORMALSIZE);
    private final ComputedStyle parentStyle;
    private final FontFamily fontFamily;
    private final FontSize fontSize;

    public ComputedStyle(ComputedStyle parentStyle, FontFamily fontFamily, FontSize fontSize) {
        this.parentStyle = parentStyle;
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
    }

    public ComputedStyle getParentStyle() {
        return this.parentStyle;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public FontSize getFontSize() {
        return this.fontSize;
    }

    public boolean isEquivalentTo(ComputedStyle other) {
        return this.fontFamily == other.fontFamily && this.fontSize == other.fontSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toString(this.hashCode(), 16) + "(fontFamily=" + (Object)((Object)this.fontFamily) + ",fontSize=" + (Object)((Object)this.fontSize) + ",parentStyle=" + (this.parentStyle != null ? Integer.toString(this.parentStyle.hashCode(), 16) : null) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontSize {
        TINY("tiny"),
        SCRIPTSIZE("scriptsize"),
        FOOTNOTESIZE("footnotesize"),
        SMALL("small"),
        NORMALSIZE("normalsize"),
        LARGE("large"),
        LARGE_2("large2"),
        LARGE_3("large3"),
        HUGE("huge"),
        HUGE_2("huge2");

        private final String targetCSSClassName;

        private FontSize(String targetCSSClassName) {
            this.targetCSSClassName = targetCSSClassName;
        }

        public String getTargetCSSClassName() {
            return this.targetCSSClassName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontFamily {
        NORMAL("div", "rm", "span", "rm", "normal"),
        BF("div", "bf", "b", null, "bold"),
        RM("div", "rm", "span", "rm", "normal"),
        EM("div", "em", "em", null, "italic"),
        IT("div", "it", "i", null, "italic"),
        TT("div", "tt", "span", "tt", "monospace"),
        SC("div", "sc", "span", "sc", null),
        SL("div", "sl", "span", "sl", null),
        SF("div", "sf", "span", "sf", "sans-serif");

        private final String targetBlockXHTMLElementName;
        private final String targetBlockCSSClassName;
        private final String targetInlineXHTMLElementName;
        private final String targetInlineCSSClassName;
        private final String targetMathMLMathVariantName;

        private FontFamily(String targetBlockXHTMLElementName, String targetBlockCSSClassName, String targetInlineXHTMLElementName, String targetInlineCSSClassName, String targetMathMLMathVariantName) {
            this.targetBlockXHTMLElementName = targetBlockXHTMLElementName;
            this.targetBlockCSSClassName = targetBlockCSSClassName;
            this.targetInlineXHTMLElementName = targetInlineXHTMLElementName;
            this.targetInlineCSSClassName = targetInlineCSSClassName;
            this.targetMathMLMathVariantName = targetMathMLMathVariantName;
        }

        public String getTargetBlockXHTMLElementName() {
            return this.targetBlockXHTMLElementName;
        }

        public String getTargetBlockCSSClassName() {
            return this.targetBlockCSSClassName;
        }

        public String getTargetInlineXHTMLElementName() {
            return this.targetInlineXHTMLElementName;
        }

        public String getTargetInlineCSSClassName() {
            return this.targetInlineCSSClassName;
        }

        public String getTargetMathMLMathVariantName() {
            return this.targetMathMLMathVariantName;
        }
    }
}

