/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import uk.ac.ed.ph.snuggletex.InputContext;
import uk.ac.ed.ph.snuggletex.NumberMatcher;

public class DecimalFormatNumberMatcher
implements NumberMatcher {
    private static final int READAHEAD_INCREMENT = 4;
    private DecimalFormat decimalFormat;

    public DecimalFormatNumberMatcher() {
        this(Locale.getDefault());
    }

    public DecimalFormatNumberMatcher(Locale locale) {
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        this.decimalFormat.setGroupingUsed(false);
    }

    public DecimalFormatNumberMatcher(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public int getNumberEnd(InputContext input, int startIndex) {
        this.decimalFormat.setParseBigDecimal(true);
        int maxReadAhead = input.length() - startIndex;
        int readAhead = Math.min(4, maxReadAhead);
        int endIndex = -1;
        if (readAhead > 0) {
            ParsePosition parsePosition;
            String candidate;
            BigDecimal parsed;
            while ((parsed = (BigDecimal)this.decimalFormat.parse(candidate = input.extract(startIndex, startIndex + readAhead).toString(), parsePosition = new ParsePosition(0))) != null && parsed.compareTo(BigDecimal.ZERO) >= 0) {
                if (parsePosition.getIndex() == readAhead && readAhead < maxReadAhead) {
                    readAhead = Math.min(readAhead + 4, maxReadAhead);
                    continue;
                }
                endIndex = startIndex + parsePosition.getIndex();
                break;
            }
        }
        return endIndex;
    }
}

