/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.internal.win32;

import com.google.common.collect.Lists;
import com.jetbrains.python.internal.IProcessList;
import com.jetbrains.python.internal.ProcessUtils;
import com.jetbrains.python.internal.PyProcessInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ProcessListWin32Internal
implements IProcessList {
    private PyProcessInfo[] NOPROCESS = new PyProcessInfo[0];
    private String myHelpersRoot;

    public ProcessListWin32Internal(String helpersRoot) {
        this.myHelpersRoot = helpersRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PyProcessInfo[] getProcessList() {
        PyProcessInfo[] procInfos;
        block7: {
            Process p = null;
            String command = null;
            InputStream in = null;
            procInfos = this.NOPROCESS;
            try {
                File file = new File(this.myHelpersRoot, "process/listtasks.exe");
                if (file == null || !file.exists() || (command = file.getCanonicalPath()) == null) break block7;
                try {
                    p = ProcessUtils.createProcess(new String[]{command}, null, null);
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    procInfos = this.parseListTasks(reader);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return procInfos;
    }

    public PyProcessInfo[] parseListTasks(InputStreamReader reader) {
        BufferedReader br = new BufferedReader(reader);
        ArrayList processList = Lists.newArrayList();
        block4: while (true) {
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int tab = line.indexOf(9);
                    if (tab == -1) continue;
                    String proc = line.substring(0, tab).trim();
                    String name = line.substring(tab).trim();
                    if (proc.length() <= 0 || name.length() <= 0) continue;
                    try {
                        int pid = Integer.parseInt(proc);
                        processList.add(new PyProcessInfo(pid, name));
                        continue block4;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break;
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        return processList.toArray(new PyProcessInfo[processList.size()]);
    }
}

