/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.internal.win32;

import com.google.common.base.Joiner;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.internal.IProcessList;
import com.jetbrains.python.internal.ProcessUtils;
import com.jetbrains.python.internal.PyProcessInfo;
import com.jetbrains.python.internal.win32.CSVReader;
import com.jetbrains.python.internal.win32.ProcessListWin32Internal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ProcessListWin32
implements IProcessList {
    private static final Logger LOG = Logger.getInstance(ProcessListWin32.class);
    private String myHelpersRoot;

    public ProcessListWin32(String helpersRoot) {
        this.myHelpersRoot = helpersRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PyProcessInfo[] getProcessList() {
        try {
            return this.createFromWMIC();
        }
        catch (Exception e) {
            Process p = null;
            InputStream in = null;
            PyProcessInfo[] procInfos = new PyProcessInfo[]{};
            try {
                try {
                    try {
                        p = ProcessUtils.createProcess(new String[]{"tasklist.exe", "/fo", "csv", "/nh", "/v"}, null, null);
                    }
                    catch (Exception e2) {
                        PyProcessInfo[] pyProcessInfoArray = new ProcessListWin32Internal(this.myHelpersRoot).getProcessList();
                        if (in != null) {
                            in.close();
                        }
                        if (p == null) return pyProcessInfoArray;
                        p.destroy();
                        return pyProcessInfoArray;
                    }
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    procInfos = this.parseListTasks(reader);
                    return procInfos;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException e3) {
                // empty catch block
            }
            return procInfos;
        }
    }

    private PyProcessInfo[] createFromWMIC() throws Exception {
        Process p = ProcessUtils.createProcess(new String[]{"wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline"}, null, null);
        ArrayList<PyProcessInfo> lst = new ArrayList<PyProcessInfo>();
        InputStream in = p.getInputStream();
        InputStreamReader reader = new InputStreamReader(in);
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = br.readLine();
            int commandLineI = line.indexOf("CommandLine");
            int processIdI = line.indexOf("ProcessId");
            if (commandLineI == -1) {
                throw new AssertionError((Object)("Could not find CommandLine in: " + line));
            }
            if (processIdI == -1) {
                throw new AssertionError((Object)("Could not find ProcessId in: " + line));
            }
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String name = line.substring(0, commandLineI).trim();
                String commandLine = line.substring(commandLineI, processIdI).trim();
                String processId = line.substring(processIdI, line.length()).trim();
                lst.add(new PyProcessInfo(Integer.parseInt(processId), name + "   " + commandLine));
            }
            if (lst.size() == 0) {
                throw new AssertionError((Object)"Error: no processes found");
            }
            PyProcessInfo[] pyProcessInfoArray = lst.toArray(new PyProcessInfo[0]);
            return pyProcessInfoArray;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw e;
        }
        finally {
            in.close();
        }
    }

    public PyProcessInfo[] parseListTasks(InputStreamReader reader) {
        String[] next;
        BufferedReader br = new BufferedReader(reader);
        CSVReader csvReader = new CSVReader(br);
        ArrayList<PyProcessInfo> processList = new ArrayList<PyProcessInfo>();
        do {
            try {
                next = csvReader.readNext();
                if (next == null) continue;
                int pid = Integer.parseInt(next[1]);
                String name = Joiner.on((String)" - ").join((Object)next[0], (Object)next[next.length - 1], new Object[0]);
                processList.add(new PyProcessInfo(pid, name));
            }
            catch (IOException e) {
                break;
            }
        } while (next != null);
        return processList.toArray(new PyProcessInfo[processList.size()]);
    }
}

