/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.internal.macos;

import com.google.common.collect.Lists;
import com.jetbrains.python.internal.IProcessList;
import com.jetbrains.python.internal.ProcessUtils;
import com.jetbrains.python.internal.PyProcessInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ProcessListMac
implements IProcessList {
    PyProcessInfo[] empty = new PyProcessInfo[0];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PyProcessInfo[] getProcessList() {
        BufferedReader psOutput;
        Process ps;
        String[] args = new String[]{"/bin/ps", "-a", "-x", "-o", "pid,command"};
        try {
            ps = ProcessUtils.createProcess(args, null, null);
            psOutput = new BufferedReader(new InputStreamReader(ps.getInputStream()));
        }
        catch (Exception e) {
            return new PyProcessInfo[0];
        }
        ArrayList procInfo = Lists.newArrayList();
        try {
            String lastline;
            while ((lastline = psOutput.readLine()) != null) {
                int index = (lastline = lastline.trim()).indexOf(32);
                if (index == -1) continue;
                String pidString = lastline.substring(0, index).trim();
                try {
                    int pid = Integer.parseInt(pidString);
                    String arg = lastline.substring(index + 1);
                    procInfo.add(new PyProcessInfo(pid, arg));
                }
                catch (NumberFormatException e) {
                }
            }
            psOutput.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        ps.destroy();
        return procInfo.toArray(new PyProcessInfo[procInfo.size()]);
    }
}

