/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.internal.linux;

import com.jetbrains.python.internal.IProcessList;
import com.jetbrains.python.internal.ProcessUtils;
import com.jetbrains.python.internal.PyProcessInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class ProcessListLinux
implements IProcessList {
    PyProcessInfo[] empty = new PyProcessInfo[0];

    @Override
    public PyProcessInfo[] getProcessList() {
        File proc = new File("/proc");
        File[] pidFiles = null;
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isPID = false;
                    try {
                        Integer.parseInt(name);
                        isPID = true;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    return isPID;
                }
            };
            pidFiles = proc.listFiles(filter);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        PyProcessInfo[] processInfo = this.empty;
        if (pidFiles != null) {
            processInfo = new PyProcessInfo[pidFiles.length];
            for (int i = 0; i < pidFiles.length; ++i) {
                String name;
                File cmdLine = new File(pidFiles[i], "cmdline");
                try {
                    name = new String(ProcessUtils.loadFileText(cmdLine, null)).replace('\u0000', ' ');
                }
                catch (IOException e) {
                    name = "";
                }
                if (name.length() == 0) {
                    name = "Unknown";
                }
                processInfo[i] = new PyProcessInfo(pidFiles[i].getName(), name);
            }
        } else {
            pidFiles = new File[]{};
        }
        return processInfo;
    }
}

