/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.internal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.python.console.pydev.FastStringBuffer;
import com.jetbrains.python.internal.IProcessList;
import com.jetbrains.python.internal.PyProcessInfo;
import com.jetbrains.python.internal.linux.ProcessListLinux;
import com.jetbrains.python.internal.macos.ProcessListMac;
import com.jetbrains.python.internal.win32.ProcessListWin32;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessUtils {
    private static final Logger LOG = Logger.getInstance(ProcessUtils.class);

    public static Process createProcess(String[] cmdarray, String[] envp, File workingDir) throws IOException {
        return Runtime.getRuntime().exec(ProcessUtils.getWithoutEmptyParams(cmdarray), ProcessUtils.getWithoutEmptyParams(envp), workingDir);
    }

    private static String[] getWithoutEmptyParams(String[] cmdarray) {
        if (cmdarray == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String string : cmdarray) {
            if (string == null || string.length() <= 0) continue;
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    public static IProcessList getProcessList(String helpersRoot) {
        if (SystemInfo.isWindows) {
            return new ProcessListWin32(helpersRoot);
        }
        if (SystemInfo.isLinux) {
            return new ProcessListLinux();
        }
        if (SystemInfo.isMac) {
            return new ProcessListMac();
        }
        LOG.error("Unexpected platform. Unable to list processes.");
        return new IProcessList(){

            @Override
            public PyProcessInfo[] getProcessList() {
                return new PyProcessInfo[0];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block4: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/internal/ProcessUtils", "loadFileText"));
            }
            FileInputStream stream = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            cArray = ProcessUtils.loadText(reader);
            if (cArray != null) break block4;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/internal/ProcessUtils", "loadFileText"));
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/python/internal/ProcessUtils", "loadText"));
        }
        int BUFFER_SIZE = 2048;
        char[] readBuffer = new char[BUFFER_SIZE];
        int n = reader.read(readBuffer);
        int DEFAULT_FILE_SIZE = 8 * BUFFER_SIZE;
        FastStringBuffer buffer = new FastStringBuffer(DEFAULT_FILE_SIZE);
        while (n > 0) {
            buffer.append(readBuffer, 0, n);
            n = reader.read(readBuffer);
        }
        char[] cArray = buffer.toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/internal/ProcessUtils", "loadText"));
        }
        return cArray;
    }
}

