/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyIo;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractThreadCommand;
import com.jetbrains.python.debugger.pydev.ChangeVariableCommand;
import com.jetbrains.python.debugger.pydev.ConsoleExecCommand;
import com.jetbrains.python.debugger.pydev.EvaluateCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.GetArrayCommand;
import com.jetbrains.python.debugger.pydev.GetCompletionsCommand;
import com.jetbrains.python.debugger.pydev.GetFrameCommand;
import com.jetbrains.python.debugger.pydev.GetReferrersCommand;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.LoadSourceCommand;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.RemoveBreakpointCommand;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.pydev.RunCommand;
import com.jetbrains.python.debugger.pydev.SetBreakpointCommand;
import com.jetbrains.python.debugger.pydev.SmartStepIntoCommand;
import com.jetbrains.python.debugger.pydev.SuspendCommand;
import com.jetbrains.python.debugger.pydev.VersionCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDebugger
implements ProcessDebugger {
    private static final int RESPONSE_TIMEOUT = 60000;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.pydev.remote.RemoteDebugger");
    private static final String LOCAL_VERSION = "0.1";
    public static final String TEMP_VAR_PREFIX = "__py_debug_temp_var_";
    private static final SecureRandom ourRandom = new SecureRandom();
    private final IPyDebugProcess myDebugProcess;
    @NotNull
    private final ServerSocket myServerSocket;
    private final int myConnectionTimeout;
    private final Object mySocketObject;
    private Socket mySocket;
    private volatile boolean myConnected;
    private int mySequence;
    private final Object mySequenceObject;
    private final Map<String, PyThreadInfo> myThreads;
    private final Map<Integer, ProtocolFrame> myResponseQueue;
    private final TempVarsHolder myTempVars;
    private Map<Pair<String, Integer>, String> myTempBreakpoints;
    private final List<RemoteDebuggerCloseListener> myCloseListeners;
    private DebuggerReader myDebuggerReader;

    public RemoteDebugger(IPyDebugProcess debugProcess, @NotNull ServerSocket serverSocket, int timeout) {
        if (serverSocket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/debugger/pydev/RemoteDebugger", "<init>"));
        }
        this.mySocketObject = new Object();
        this.myConnected = false;
        this.mySequence = -1;
        this.mySequenceObject = new Object();
        this.myThreads = new ConcurrentHashMap<String, PyThreadInfo>();
        this.myResponseQueue = new HashMap<Integer, ProtocolFrame>();
        this.myTempVars = new TempVarsHolder();
        this.myTempBreakpoints = Maps.newHashMap();
        this.myCloseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDebugProcess = debugProcess;
        this.myServerSocket = serverSocket;
        this.myConnectionTimeout = timeout;
    }

    public IPyDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @Override
    public boolean isConnected() {
        return this.myConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnect() throws Exception {
        this.myServerSocket.setSoTimeout(this.myConnectionTimeout);
        Object object = this.mySocketObject;
        synchronized (object) {
            this.mySocket = this.myServerSocket.accept();
            this.myConnected = true;
        }
        if (this.myConnected) {
            try {
                this.myDebuggerReader = this.createReader();
            }
            catch (Exception e) {
                Object object2 = this.mySocketObject;
                synchronized (object2) {
                    this.mySocket.close();
                }
                throw e;
            }
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        VersionCommand command = new VersionCommand(this, LOCAL_VERSION, SystemInfo.isUnix ? "UNIX" : "WIN");
        command.execute();
        String version = command.getRemoteVersion();
        if (version != null) {
            version = version.trim();
        }
        return version;
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute) throws PyDebuggerException {
        return this.evaluate(threadId, frameId, expression, execute, true);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute, boolean trimResult) throws PyDebuggerException {
        EvaluateCommand command = new EvaluateCommand(this, threadId, frameId, expression, execute, trimResult);
        command.execute();
        return command.getValue();
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        ConsoleExecCommand command = new ConsoleExecCommand(this, threadId, frameId, expression);
        command.execute(callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId) throws PyDebuggerException {
        GetFrameCommand command = new GetFrameCommand(this, threadId, frameId);
        command.execute();
        return command.getVariables();
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        this.setTempVariable(threadId, frameId, var);
        GetVariableCommand command = new GetVariableCommand(this, threadId, frameId, var);
        command.execute();
        return command.getVariables();
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        GetArrayCommand command = new GetArrayCommand(this, threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
        command.execute();
        return command.getArray();
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, final PyDebugCallback<XValueChildrenList> callback) {
        GetReferrersCommand cmd = new GetReferrersCommand(this, threadId, frameId, var);
        cmd.execute(new PyDebugCallback<List<PyDebugValue>>(){

            @Override
            public void ok(List<PyDebugValue> value) {
                XValueChildrenList list = new XValueChildrenList();
                for (PyDebugValue v : value) {
                    list.add((XNamedValue)v);
                }
                callback.ok(list);
            }

            @Override
            public void error(PyDebuggerException exception) {
                callback.error(exception);
            }
        });
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        this.setTempVariable(threadId, frameId, var);
        return this.doChangeVariable(threadId, frameId, var.getEvaluationExpression(), value);
    }

    private PyDebugValue doChangeVariable(String threadId, String frameId, String varName, String value) throws PyDebuggerException {
        ChangeVariableCommand command = new ChangeVariableCommand(this, threadId, frameId, varName, value);
        command.execute();
        return command.getNewValue();
    }

    @Override
    @Nullable
    public String loadSource(String path) {
        LoadSourceCommand command = new LoadSourceCommand(this, path);
        try {
            command.execute();
            return command.getContent();
        }
        catch (PyDebuggerException e) {
            return "#Couldn't load source of file " + path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        this.myThreads.clear();
        this.myResponseQueue.clear();
        Object object = this.mySequenceObject;
        synchronized (object) {
            this.mySequence = -1;
        }
        this.myTempVars.clear();
    }

    private void setTempVariable(String threadId, String frameId, PyDebugValue var) {
        PyDebugValue topVar = var.getTopParent();
        if (!this.myDebugProcess.canSaveToTemp(topVar.getName())) {
            return;
        }
        if (this.myTempVars.contains(threadId, frameId, topVar.getTempName())) {
            return;
        }
        topVar.setTempName(RemoteDebugger.generateTempName());
        try {
            this.doChangeVariable(threadId, frameId, topVar.getTempName(), topVar.getName());
            this.myTempVars.put(threadId, frameId, topVar.getTempName());
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
            topVar.setTempName(null);
        }
    }

    private void clearTempVariables(String threadId) {
        Map threadVars = this.myTempVars.get(threadId);
        if (threadVars == null || threadVars.size() == 0) {
            return;
        }
        for (Map.Entry entry : threadVars.entrySet()) {
            Set frameVars = (Set)entry.getValue();
            if (frameVars == null || frameVars.size() == 0) continue;
            String expression = "del " + StringUtil.join((Collection)frameVars, (String)",");
            try {
                this.evaluate(threadId, (String)entry.getKey(), expression, true);
            }
            catch (PyDebuggerException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTempVars.clear(threadId);
    }

    private static String generateTempName() {
        return TEMP_VAR_PREFIX + ourRandom.nextInt(Integer.MAX_VALUE);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        return Collections.unmodifiableCollection(new ArrayList<PyThreadInfo>(this.myThreads.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextSequence() {
        Object object = this.mySequenceObject;
        synchronized (object) {
            this.mySequence += 2;
            return this.mySequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void placeResponse(int sequence, ProtocolFrame response) {
        Map<Integer, ProtocolFrame> map = this.myResponseQueue;
        synchronized (map) {
            if (response == null || this.myResponseQueue.containsKey(sequence)) {
                this.myResponseQueue.put(sequence, response);
            }
            if (response != null) {
                this.myResponseQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ProtocolFrame waitForResponse(int sequence) {
        ProtocolFrame response;
        long until = System.currentTimeMillis() + 60000L;
        Map<Integer, ProtocolFrame> map = this.myResponseQueue;
        synchronized (map) {
            do {
                try {
                    this.myResponseQueue.wait(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while ((response = this.myResponseQueue.get(sequence)) == null && this.isConnected() && System.currentTimeMillis() < until);
            this.myResponseQueue.remove(sequence);
        }
        return response;
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/debugger/pydev/RemoteDebugger", "execute"));
        }
        if (command instanceof ResumeOrStepCommand) {
            String threadId = ((ResumeOrStepCommand)command).getThreadId();
            this.clearTempVariables(threadId);
        }
        try {
            command.execute();
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendFrame(ProtocolFrame frame) {
        RemoteDebugger.logFrame(frame, true);
        try {
            byte[] packed = frame.pack();
            Object object = this.mySocketObject;
            synchronized (object) {
                OutputStream os = this.mySocket.getOutputStream();
                os.write(packed);
                os.flush();
                return true;
            }
        }
        catch (SocketException se) {
            this.disconnect();
            this.fireCommunicationError();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static void logFrame(ProtocolFrame frame, boolean out) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%1$tH:%1$tM:%1$tS.%1$tL %2$s %3$s\n", new Date(), out ? "<<<" : ">>>", frame));
        }
    }

    @Override
    public void suspendAllThreads() {
        for (PyThreadInfo thread : this.getThreads()) {
            this.suspendThread(thread.getId());
        }
    }

    @Override
    public void suspendThread(String threadId) {
        SuspendCommand command = new SuspendCommand(this, threadId);
        this.execute(command);
    }

    @Override
    public void close() {
        if (!this.myServerSocket.isClosed()) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing socket", (Throwable)e);
            }
        }
        if (this.myDebuggerReader != null) {
            this.myDebuggerReader.stop();
        }
        this.fireCloseEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.mySocketObject;
        synchronized (object) {
            this.myConnected = false;
            if (this.mySocket != null && !this.mySocket.isClosed()) {
                try {
                    this.mySocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.cleanUp();
    }

    @Override
    public void run() throws PyDebuggerException {
        new RunCommand(this).execute();
    }

    @Override
    public void smartStepInto(String threadId, String functionName) {
        SmartStepIntoCommand command = new SmartStepIntoCommand(this, threadId, functionName);
        this.execute(command);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        ResumeOrStepCommand command = new ResumeOrStepCommand(this, threadId, mode);
        this.execute(command);
    }

    @Override
    public void setTempBreakpoint(String type, String file, int line) {
        SetBreakpointCommand command = new SetBreakpointCommand(this, type, file, line);
        this.execute(command);
        this.myTempBreakpoints.put((Pair<String, Integer>)Pair.create((Object)file, (Object)line), type);
    }

    @Override
    public void removeTempBreakpoint(String file, int line) {
        String type = this.myTempBreakpoints.get(Pair.create((Object)file, (Object)line));
        if (type != null) {
            RemoveBreakpointCommand command = new RemoveBreakpointCommand(this, type, file, line);
            this.execute(command);
        } else {
            LOG.error("Temp breakpoint not found for " + file + ":" + line);
        }
    }

    @Override
    public void setBreakpoint(String typeId, String file, int line, String condition, String logExpression) {
        SetBreakpointCommand command = new SetBreakpointCommand(this, typeId, file, line, condition, logExpression);
        this.execute(command);
    }

    @Override
    public void setBreakpointWithFuncName(String typeId, String file, int line, String condition, String logExpression, String funcName) {
        SetBreakpointCommand command = new SetBreakpointCommand(this, typeId, file, line, condition, logExpression, funcName);
        this.execute(command);
    }

    @Override
    public void removeBreakpoint(String typeId, String file, int line) {
        RemoveBreakpointCommand command = new RemoveBreakpointCommand(this, typeId, file, line);
        this.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebuggerReader createReader() throws IOException {
        Object object = this.mySocketObject;
        synchronized (object) {
            return new DebuggerReader(this.mySocket.getInputStream());
        }
    }

    private void writeToConsole(PyIo io) {
        ConsoleViewContentType contentType = io.getCtx() == 2 ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
        this.myDebugProcess.printToConsole(io.getText(), contentType);
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener) {
        this.myCloseListeners.add(listener);
    }

    public void removeCloseListener(RemoteDebuggerCloseListener listener) {
        this.myCloseListeners.remove(listener);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        GetCompletionsCommand command = new GetCompletionsCommand(this, threadId, frameId, prefix);
        this.execute(command);
        return command.getCompletions();
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        this.execute(factory.createAddCommand(this));
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        this.execute(factory.createRemoveCommand(this));
    }

    private void fireCloseEvent() {
        for (RemoteDebuggerCloseListener listener : this.myCloseListeners) {
            listener.closed();
        }
    }

    private void fireCommunicationError() {
        for (RemoteDebuggerCloseListener listener : this.myCloseListeners) {
            listener.communicationError();
        }
    }

    private void fireExitEvent() {
        for (RemoteDebuggerCloseListener listener : this.myCloseListeners) {
            listener.detached();
        }
    }

    private static class TempVarsHolder {
        private final Map<String, Map<String, Set<String>>> myData = new HashMap<String, Map<String, Set<String>>>();

        private TempVarsHolder() {
        }

        public boolean contains(String threadId, String frameId, String name) {
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars == null) {
                return false;
            }
            Set<String> frameVars = threadVars.get(frameId);
            if (frameVars == null) {
                return false;
            }
            return frameVars.contains(name);
        }

        private void put(String threadId, String frameId, String name) {
            Set<String> frameVars;
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars == null) {
                threadVars = new HashMap<String, Set<String>>();
                this.myData.put(threadId, threadVars);
            }
            if ((frameVars = threadVars.get(frameId)) == null) {
                frameVars = new HashSet<String>();
                threadVars.put(frameId, frameVars);
            }
            frameVars.add(name);
        }

        private Map<String, Set<String>> get(String threadId) {
            return this.myData.get(threadId);
        }

        private void clear() {
            this.myData.clear();
        }

        private void clear(String threadId) {
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars != null) {
                threadVars.clear();
            }
        }
    }

    private class DebuggerReader
    extends BaseOutputReader {
        private StringBuilder myTextBuilder;
        private final InputStream myInputStream;

        private DebuggerReader(InputStream stream) throws IOException {
            super((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
            this.myTextBuilder = new StringBuilder();
            this.myInputStream = stream;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            try {
                boolean read;
                while (read = this.readAvailableBlocking()) {
                    if (this.isStopped) {
                        break;
                    }
                    TimeoutUtil.sleep((long)this.mySleepingPolicy.getTimeToSleep(true));
                }
            }
            catch (Exception e) {
                RemoteDebugger.this.fireCommunicationError();
            }
            finally {
                this.close();
                RemoteDebugger.this.fireExitEvent();
            }
        }

        private void processResponse(String line) {
            try {
                ProtocolFrame frame = new ProtocolFrame(line);
                RemoteDebugger.logFrame(frame, false);
                if (AbstractThreadCommand.isThreadCommand(frame.getCommand())) {
                    this.processThreadEvent(frame);
                } else if (AbstractCommand.isWriteToConsole(frame.getCommand())) {
                    RemoteDebugger.this.writeToConsole(ProtocolParser.parseIo(frame.getPayload()));
                } else if (AbstractCommand.isExitEvent(frame.getCommand())) {
                    RemoteDebugger.this.fireCommunicationError();
                } else if (AbstractCommand.isCallSignatureTrace(frame.getCommand())) {
                    this.recordCallSignature(ProtocolParser.parseCallSignature(frame.getPayload()));
                } else {
                    RemoteDebugger.this.placeResponse(frame.getSequence(), frame);
                }
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }

        private void recordCallSignature(PySignature signature) {
            RemoteDebugger.this.myDebugProcess.recordSignature(signature);
        }

        private void processThreadEvent(ProtocolFrame frame) throws PyDebuggerException {
            switch (frame.getCommand()) {
                case 103: {
                    PyThreadInfo thread = this.parseThreadEvent(frame);
                    if (thread.isPydevThread()) break;
                    RemoteDebugger.this.myThreads.put(thread.getId(), thread);
                    break;
                }
                case 105: {
                    PyThreadInfo event = this.parseThreadEvent(frame);
                    PyThreadInfo thread = (PyThreadInfo)RemoteDebugger.this.myThreads.get(event.getId());
                    if (thread == null) {
                        LOG.error("Trying to stop on non-existent thread: " + event.getId() + ", " + event.getStopReason() + ", " + event.getMessage());
                        RemoteDebugger.this.myThreads.put(event.getId(), event);
                        thread = event;
                    }
                    thread.updateState(PyThreadInfo.State.SUSPENDED, event.getFrames());
                    thread.setStopReason(event.getStopReason());
                    thread.setMessage(event.getMessage());
                    RemoteDebugger.this.myDebugProcess.threadSuspended(thread);
                    break;
                }
                case 106: {
                    String id = ProtocolParser.getThreadId(frame.getPayload());
                    PyThreadInfo thread = (PyThreadInfo)RemoteDebugger.this.myThreads.get(id);
                    if (thread == null) break;
                    thread.updateState(PyThreadInfo.State.RUNNING, null);
                    RemoteDebugger.this.myDebugProcess.threadResumed(thread);
                    break;
                }
                case 104: {
                    String id = frame.getPayload();
                    PyThreadInfo thread = (PyThreadInfo)RemoteDebugger.this.myThreads.get(id);
                    if (thread == null) break;
                    thread.updateState(PyThreadInfo.State.KILLED, null);
                    RemoteDebugger.this.myThreads.remove(id);
                    break;
                }
                case 142: {
                    PyThreadInfo event = this.parseThreadEvent(frame);
                    PyThreadInfo thread = (PyThreadInfo)RemoteDebugger.this.myThreads.get(event.getId());
                    if (thread == null) {
                        RemoteDebugger.this.myThreads.put(event.getId(), event);
                        thread = event;
                    }
                    thread.updateState(PyThreadInfo.State.SUSPENDED, event.getFrames());
                    thread.setStopReason(event.getStopReason());
                    thread.setMessage(event.getMessage());
                    RemoteDebugger.this.myDebugProcess.showConsole(thread);
                    break;
                }
            }
        }

        private PyThreadInfo parseThreadEvent(ProtocolFrame frame) throws PyDebuggerException {
            return ProtocolParser.parseThread(frame.getPayload(), RemoteDebugger.this.myDebugProcess.getPositionConverter());
        }

        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }

        public void close() {
            try {
                this.myInputStream.close();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public void stop() {
            super.stop();
            this.close();
        }

        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/debugger/pydev/RemoteDebugger$DebuggerReader", "onTextAvailable"));
            }
            this.myTextBuilder.append(text);
            if (text.contains("\n")) {
                String[] lines = this.myTextBuilder.toString().split("\n");
                this.myTextBuilder = new StringBuilder();
                if (!text.endsWith("\n")) {
                    this.myTextBuilder.append(lines[lines.length - 1]);
                    lines = Arrays.copyOfRange(lines, 0, lines.length - 1);
                }
                for (String line : lines) {
                    this.processResponse(line + "\n");
                }
            }
        }
    }
}

