/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyIo;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class ProtocolParser {
    private ProtocolParser() {
    }

    public static PySignature parseCallSignature(String payload) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(payload, true);
        reader.moveDown();
        if (!"call_signature".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <call_signature>, found " + reader.getNodeName());
        }
        String file = ProtocolParser.readString(reader, "file", "");
        String name = ProtocolParser.readString(reader, "name", "");
        PySignature signature = new PySignature(file, name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"arg".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <arg>, found " + reader.getNodeName());
            }
            signature.addArgument(ProtocolParser.readString(reader, "name", ""), ProtocolParser.readString(reader, "type", ""));
            reader.moveUp();
        }
        return signature;
    }

    public static String parseSourceContent(String payload) throws PyDebuggerException {
        return payload;
    }

    public static String decode(String value) throws PyDebuggerException {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PyDebuggerException("Unable to decode: " + value + ", reason: " + e.getMessage());
        }
    }

    public static String encodeExpression(String expression) {
        return StringUtil.replace((String)expression, (String)"\n", (String)"@LINE@");
    }

    public static PyIo parseIo(String text) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        if (!"io".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <io>, found " + reader.getNodeName());
        }
        String s = ProtocolParser.readString(reader, "s", "");
        int ctx = ProtocolParser.readInt(reader, "ctx", 1);
        return new PyIo(s, ctx);
    }

    @NotNull
    public static PyThreadInfo parseThread(String text, PyPositionConverter positionConverter) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        if (!"thread".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <thread>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name = ProtocolParser.readString(reader, "name", "");
        int stopReason = ProtocolParser.readInt(reader, "stop_reason", 0);
        String message = ProtocolParser.readString(reader, "message", "None");
        if ("None".equals(message)) {
            message = null;
        }
        LinkedList<PyStackFrameInfo> frames = new LinkedList<PyStackFrameInfo>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            frames.add(ProtocolParser.parseFrame(reader, id, positionConverter));
            reader.moveUp();
        }
        PyThreadInfo pyThreadInfo = new PyThreadInfo(id, name, frames, stopReason, message);
        if (pyThreadInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolParser", "parseThread"));
        }
        return pyThreadInfo;
    }

    @NotNull
    public static String getThreadId(@NotNull String payload) {
        if (payload == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "payload", "com/jetbrains/python/debugger/pydev/ProtocolParser", "getThreadId"));
        }
        String string = payload.split("\t")[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolParser", "getThreadId"));
        }
        return string;
    }

    private static PyStackFrameInfo parseFrame(XppReader reader, String threadId, PyPositionConverter positionConverter) throws PyDebuggerException {
        if (!"frame".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <frame>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name = ProtocolParser.readString(reader, "name", null);
        String file = ProtocolParser.readString(reader, "file", null);
        int line = ProtocolParser.readInt(reader, "line", 0);
        return new PyStackFrameInfo(threadId, id, name, positionConverter.create(file, line));
    }

    @NotNull
    public static PyDebugValue parseValue(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        PyDebugValue pyDebugValue = ProtocolParser.parseValue(reader, frameAccessor);
        if (pyDebugValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolParser", "parseValue"));
        }
        return pyDebugValue;
    }

    @NotNull
    public static List<PyDebugValue> parseReferrers(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("var")) {
                PyDebugValue value = ProtocolParser.parseValue(reader, frameAccessor);
                value.setId(ProtocolParser.readString(reader, "id", null));
                values.add(value);
            } else if (!reader.getNodeName().equals("for")) {
                throw new PyDebuggerException("Expected <var> or <for>, found " + reader.getNodeName());
            }
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolParser", "parseReferrers"));
        }
        return linkedList;
    }

    @NotNull
    public static List<PyDebugValue> parseValues(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            values.add(ProtocolParser.parseValue(reader, frameAccessor));
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolParser", "parseValues"));
        }
        return linkedList;
    }

    private static PyDebugValue parseValue(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        if (!"var".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <var>, found " + reader.getNodeName());
        }
        String name = ProtocolParser.readString(reader, "name", null);
        String type = ProtocolParser.readString(reader, "type", null);
        String value = ProtocolParser.readString(reader, "value", null);
        String isContainer = ProtocolParser.readString(reader, "isContainer", "");
        String isErrorOnEval = ProtocolParser.readString(reader, "isErrorOnEval", "");
        if (value.startsWith(type + ": ")) {
            value = value.substring(type.length() + 2);
        }
        return new PyDebugValue(name, type, value, "True".equals(isContainer), "True".equals(isErrorOnEval), frameAccessor);
    }

    public static ArrayChunk parseArrayValues(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, false);
        ArrayChunk result = null;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"array".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <array> at first node, found " + reader.getNodeName());
            }
            String slice = ProtocolParser.readString(reader, "slice", null);
            int rows = ProtocolParser.readInt(reader, "rows", null);
            int cols = ProtocolParser.readInt(reader, "cols", null);
            String format = "%" + ProtocolParser.readString(reader, "format", null);
            String type = ProtocolParser.readString(reader, "type", null);
            String max = ProtocolParser.readString(reader, "max", null);
            String min = ProtocolParser.readString(reader, "min", null);
            result = new ArrayChunk(new PyDebugValue(slice, null, null, false, false, frameAccessor), slice, rows, cols, max, min, format, type, null);
            reader.moveUp();
        }
        Object[][] data = ProtocolParser.parseArrayValues(reader, frameAccessor);
        return new ArrayChunk(result.getValue(), result.getSlicePresentation(), result.getRows(), result.getColumns(), result.getMax(), result.getMin(), result.getFormat(), result.getType(), data);
    }

    public static Object[][] parseArrayValues(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        int rows = -1;
        int cols = -1;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"arraydata".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <arraydata> at second node, found " + reader.getNodeName());
            }
            rows = ProtocolParser.readInt(reader, "rows", null);
            cols = ProtocolParser.readInt(reader, "cols", null);
            reader.moveUp();
        }
        if (rows <= 0 || cols <= 0) {
            throw new PyDebuggerException("Array xml: bad rows or columns number: (" + rows + ", " + cols + ")");
        }
        Object[][] values = new Object[rows][cols];
        int currRow = 0;
        int currCol = 0;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"var".equals(reader.getNodeName()) && !"row".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <var> or <row>, found " + reader.getNodeName());
            }
            if ("row".equals(reader.getNodeName())) {
                int index = ProtocolParser.readInt(reader, "index", null);
                if (currRow != index) {
                    throw new PyDebuggerException("Array xml: expected " + currRow + " row, found " + index);
                }
                if (currRow > 0 && currCol != cols) {
                    throw new PyDebuggerException("Array xml: expected " + cols + " filled columns, got " + currCol + " instead.");
                }
                ++currRow;
                currCol = 0;
            } else {
                PyDebugValue value = ProtocolParser.parseValue(reader, frameAccessor);
                values[currRow - 1][currCol] = value.getValue();
                ++currCol;
            }
            reader.moveUp();
        }
        return values;
    }

    private static XppReader openReader(String text, boolean checkForContent) throws PyDebuggerException {
        XppReader reader = new XppReader((Reader)new StringReader(text), (XmlPullParser)new MXParser(), (NameCoder)new NoNameCoder());
        if (checkForContent && !reader.hasMoreChildren()) {
            throw new PyDebuggerException("Empty frame: " + text);
        }
        return reader;
    }

    private static String readString(XppReader reader, String name, String fallback) throws PyDebuggerException {
        String value;
        try {
            value = ProtocolParser.read(reader, name);
        }
        catch (PyDebuggerException e) {
            if (fallback != null) {
                return fallback;
            }
            throw e;
        }
        return ProtocolParser.decode(value);
    }

    private static int readInt(XppReader reader, String name, Integer fallback) throws PyDebuggerException {
        String value;
        try {
            value = ProtocolParser.read(reader, name);
        }
        catch (PyDebuggerException e) {
            if (fallback != null) {
                return fallback;
            }
            throw e;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PyDebuggerException("Unable to decode " + value + ": " + e.getMessage());
        }
    }

    private static String read(XppReader reader, String name) throws PyDebuggerException {
        String value = reader.getAttribute(name);
        if (value == null) {
            throw new PyDebuggerException("Attribute not found: " + name);
        }
        return value;
    }
}

