/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;

public class ProtocolFrame {
    private final int myCommand;
    private final int mySequence;
    @NotNull
    private final String myPayload;

    public ProtocolFrame(int command, int sequence, @NotNull String payload) throws PyDebuggerException {
        if (payload == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "payload", "com/jetbrains/python/debugger/pydev/ProtocolFrame", "<init>"));
        }
        this.myCommand = command;
        this.mySequence = sequence;
        this.myPayload = payload;
    }

    public ProtocolFrame(String frame) throws PyDebuggerException {
        String[] parts = frame.split("\t", 3);
        if (parts == null || parts.length < 2) {
            throw new PyDebuggerException("Bad frame: " + frame);
        }
        this.myCommand = Integer.parseInt(parts[0]);
        this.mySequence = Integer.parseInt(parts[1]);
        this.myPayload = parts.length == 3 && !"".equals(parts[2]) ? ProtocolParser.decode(parts[2]) : "";
    }

    public int getCommand() {
        return this.myCommand;
    }

    public int getSequence() {
        return this.mySequence;
    }

    @NotNull
    public String getPayload() {
        String string = this.myPayload;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolFrame", "getPayload"));
        }
        return string;
    }

    @NotNull
    public byte[] pack() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.myCommand));
        sb.append('\t');
        sb.append(Integer.toString(this.mySequence));
        sb.append('\t');
        sb.append(this.myPayload);
        sb.append('\n');
        byte[] byArray = sb.toString().getBytes("UTF-8");
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/ProtocolFrame", "pack"));
        }
        return byArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(Integer.toString(this.myCommand));
        sb.append(':');
        sb.append(Integer.toString(this.mySequence));
        sb.append(':');
        sb.append(this.myPayload);
        sb.append(']');
        return sb.toString();
    }
}

