/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiProcessDebugger
implements ProcessDebugger {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.pydev.remote.MultiProcessDebugger");
    private final IPyDebugProcess myDebugProcess;
    private final ServerSocket myServerSocket;
    private final int myTimeoutInMillis;
    private RemoteDebugger myMainDebugger;
    private final List<RemoteDebugger> myOtherDebuggers;
    private ServerSocket myDebugServerSocket;
    private DebuggerProcessAcceptor myDebugProcessAcceptor;
    private List<DebuggerProcessListener> myOtherDebuggerCloseListener;
    private ThreadRegistry myThreadRegistry;

    public MultiProcessDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull ServerSocket serverSocket, int timeoutInMillis) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "<init>"));
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "<init>"));
        }
        this.myOtherDebuggers = Lists.newArrayList();
        this.myOtherDebuggerCloseListener = Lists.newArrayList();
        this.myThreadRegistry = new ThreadRegistry();
        this.myDebugProcess = debugProcess;
        this.myServerSocket = serverSocket;
        this.myTimeoutInMillis = timeoutInMillis;
        try {
            this.myDebugServerSocket = MultiProcessDebugger.createServerSocket();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        this.myMainDebugger = new RemoteDebugger(this.myDebugProcess, this.myDebugServerSocket, this.myTimeoutInMillis);
    }

    @Override
    public boolean isConnected() {
        return this.myMainDebugger.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnect() throws Exception {
        final Socket socket = this.myServerSocket.accept();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiProcessDebugger.sendDebuggerPort(socket, MultiProcessDebugger.this.myDebugServerSocket, MultiProcessDebugger.this.myDebugProcess);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.myMainDebugger.waitForConnect();
        this.disposeAcceptor();
        this.myDebugProcessAcceptor = new DebuggerProcessAcceptor(this, this.myServerSocket);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myDebugProcessAcceptor);
    }

    private static void sendDebuggerPort(Socket socket, ServerSocket serverSocket, IPyDebugProcess processHandler) throws IOException {
        int port = processHandler.handleDebugPort(serverSocket.getLocalPort());
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("99\t-1\t" + port);
        writer.flush();
        socket.close();
    }

    private static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        return serverSocket;
    }

    @Override
    public void close() {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.close();
        }
        this.disposeAcceptor();
        if (!this.myServerSocket.isClosed()) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing socket", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteDebugger> allDebuggers() {
        ArrayList result = Lists.newArrayList((Object[])new RemoteDebugger[]{this.myMainDebugger});
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            result.addAll(this.myOtherDebuggers);
        }
        return result;
    }

    @Override
    public void disconnect() {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.disconnect();
        }
        this.disposeAcceptor();
    }

    private void disposeAcceptor() {
        if (this.myDebugProcessAcceptor != null) {
            this.myDebugProcessAcceptor.disconnect();
            this.myDebugProcessAcceptor = null;
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        return this.myMainDebugger.handshake();
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute, boolean trimResult) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute, trimResult);
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        this.debugger(threadId).consoleExec(threadId, frameId, expression, callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId) throws PyDebuggerException {
        return this.debugger(threadId).loadFrame(threadId, frameId);
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        return this.debugger(threadId).loadVariable(threadId, frameId, var);
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.debugger(threadId).loadArrayItems(threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        this.debugger(threadId).loadReferrers(threadId, frameId, var, callback);
    }

    @NotNull
    private ProcessDebugger debugger(@NotNull String threadId) {
        if (threadId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadId", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "debugger"));
        }
        RemoteDebugger debugger = this.myThreadRegistry.getDebugger(threadId);
        if (debugger != null) {
            RemoteDebugger remoteDebugger = debugger;
            if (remoteDebugger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "debugger"));
            }
            return remoteDebugger;
        }
        for (RemoteDebugger d : this.myOtherDebuggers) {
            for (PyThreadInfo thread : d.getThreads()) {
                if (!threadId.equals(thread.getId())) continue;
                RemoteDebugger remoteDebugger = d;
                if (remoteDebugger == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "debugger"));
                }
                return remoteDebugger;
            }
        }
        RemoteDebugger remoteDebugger = this.myMainDebugger;
        if (remoteDebugger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "debugger"));
        }
        return remoteDebugger;
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        return this.debugger(threadId).changeVariable(threadId, frameId, var, value);
    }

    @Override
    public String loadSource(String path) {
        return this.myMainDebugger.loadSource(path);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        this.cleanOtherDebuggers();
        List<PyThreadInfo> threads = this.collectAllThreads();
        if (this.myOtherDebuggers.size() > 0) {
            return Collections.unmodifiableCollection(Collections2.transform(threads, (Function)new Function<PyThreadInfo, PyThreadInfo>(){

                public PyThreadInfo apply(PyThreadInfo t) {
                    String threadName = ThreadRegistry.threadName(t.getName(), t.getId());
                    PyThreadInfo newThread = new PyThreadInfo(t.getId(), threadName, t.getFrames(), t.getStopReason(), t.getMessage());
                    newThread.updateState(t.getState(), t.getFrames());
                    return newThread;
                }
            }));
        }
        return Collections.unmodifiableCollection(threads);
    }

    private List<PyThreadInfo> collectAllThreads() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myMainDebugger.getThreads());
        for (RemoteDebugger d : this.myOtherDebuggers) {
            result.addAll(d.getThreads());
            for (PyThreadInfo t : d.getThreads()) {
                this.myThreadRegistry.register(t.getId(), d);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.removeDisconnected(this.getOtherDebuggers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisconnected(ArrayList<RemoteDebugger> debuggers) {
        boolean allConnected = true;
        for (RemoteDebugger d : debuggers) {
            if (d.isConnected()) continue;
            allConnected = false;
        }
        if (!allConnected) {
            ArrayList newList = Lists.newArrayList();
            for (RemoteDebugger d : debuggers) {
                if (!d.isConnected()) continue;
                newList.add(d);
            }
            List<RemoteDebugger> list = this.myOtherDebuggers;
            synchronized (list) {
                this.myOtherDebuggers.clear();
                this.myOtherDebuggers.addAll(newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RemoteDebugger> getOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            return Lists.newArrayList(this.myOtherDebuggers);
        }
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger", "execute"));
        }
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(command);
        }
    }

    @Override
    public void suspendAllThreads() {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.suspendAllThreads();
        }
    }

    @Override
    public void suspendThread(String threadId) {
        this.debugger(threadId).suspendThread(threadId);
    }

    @Override
    public void run() throws PyDebuggerException {
        this.myMainDebugger.run();
    }

    @Override
    public void smartStepInto(String threadId, String functionName) {
        this.debugger(threadId).smartStepInto(threadId, functionName);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        this.debugger(threadId).resumeOrStep(threadId, mode);
    }

    @Override
    public void setTempBreakpoint(String type, String file, int line) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.setTempBreakpoint(type, file, line);
        }
    }

    @Override
    public void removeTempBreakpoint(String file, int line) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.removeTempBreakpoint(file, line);
        }
    }

    @Override
    public void setBreakpoint(String typeId, String file, int line, String condition, String logExpression) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.setBreakpoint(typeId, file, line, condition, logExpression);
        }
    }

    @Override
    public void setBreakpointWithFuncName(String typeId, String file, int line, String condition, String logExpression, String funcName) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.setBreakpointWithFuncName(typeId, file, line, condition, logExpression, funcName);
        }
    }

    @Override
    public void removeBreakpoint(String typeId, String file, int line) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.removeBreakpoint(typeId, file, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDebugger(RemoteDebugger debugger) {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.myOtherDebuggers.add(debugger);
        }
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener) {
        this.myMainDebugger.addCloseListener(listener);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        return this.debugger(threadId).getCompletions(threadId, frameId, prefix);
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createAddCommand(d));
        }
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createRemoveCommand(d));
        }
    }

    public void removeCloseListener(RemoteDebuggerCloseListener listener) {
        this.myMainDebugger.removeCloseListener(listener);
    }

    public void addOtherDebuggerCloseListener(DebuggerProcessListener otherDebuggerCloseListener) {
        this.myOtherDebuggerCloseListener.add(otherDebuggerCloseListener);
    }

    public static interface DebuggerProcessListener {
        public void threadsClosed(Set<String> var1);
    }

    private static class DebuggerProcessAcceptor
    implements Runnable {
        private volatile boolean myShouldAccept;
        private final MultiProcessDebugger myMultiProcessDebugger;
        private ServerSocket myServerSocket;

        public DebuggerProcessAcceptor(@NotNull MultiProcessDebugger multiProcessDebugger, @NotNull ServerSocket serverSocket) {
            if (multiProcessDebugger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiProcessDebugger", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$DebuggerProcessAcceptor", "<init>"));
            }
            if (serverSocket == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$DebuggerProcessAcceptor", "<init>"));
            }
            this.myShouldAccept = true;
            this.myMultiProcessDebugger = multiProcessDebugger;
            this.myServerSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.myShouldAccept) {
                try {
                    ServerSocket serverSocketCopy = this.myServerSocket;
                    if (serverSocketCopy == null) break;
                    Socket socket = serverSocketCopy.accept();
                    try {
                        ServerSocket serverSocket = MultiProcessDebugger.createServerSocket();
                        RemoteDebugger debugger = new RemoteDebugger(this.myMultiProcessDebugger.myDebugProcess, serverSocket, this.myMultiProcessDebugger.myTimeoutInMillis);
                        this.addCloseListener(debugger);
                        MultiProcessDebugger.sendDebuggerPort(socket, serverSocket, this.myMultiProcessDebugger.myDebugProcess);
                        socket.close();
                        debugger.waitForConnect();
                        debugger.handshake();
                        this.myMultiProcessDebugger.addDebugger(debugger);
                        this.myMultiProcessDebugger.myDebugProcess.init();
                        debugger.run();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        if (socket.isClosed()) continue;
                        socket.close();
                    }
                }
                catch (Exception ignore) {
                    if (this.myServerSocket != null) continue;
                    this.myShouldAccept = false;
                }
            }
        }

        private void addCloseListener(final @NotNull RemoteDebugger debugger) {
            if (debugger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugger", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$DebuggerProcessAcceptor", "addCloseListener"));
            }
            debugger.addCloseListener(new RemoteDebuggerCloseListener(){

                @Override
                public void closed() {
                    DebuggerProcessAcceptor.this.notifyThreadsClosed(debugger);
                }

                @Override
                public void communicationError() {
                    DebuggerProcessAcceptor.this.notifyThreadsClosed(debugger);
                }

                @Override
                public void detached() {
                    DebuggerProcessAcceptor.this.notifyThreadsClosed(debugger);
                }
            });
        }

        private void notifyThreadsClosed(RemoteDebugger debugger) {
            for (DebuggerProcessListener l : this.myMultiProcessDebugger.myOtherDebuggerCloseListener) {
                l.threadsClosed(this.collectThreads(debugger));
            }
        }

        private Set<String> collectThreads(RemoteDebugger debugger) {
            HashSet result = Sets.newHashSet();
            for (Map.Entry entry : this.myMultiProcessDebugger.myThreadRegistry.myThreadIdToDebugger.entrySet()) {
                if (entry.getValue() != debugger) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        public void disconnect() {
            this.myShouldAccept = false;
            if (this.myServerSocket != null && !this.myServerSocket.isClosed()) {
                try {
                    this.myServerSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.myServerSocket = null;
            }
        }
    }

    private static class ThreadRegistry {
        private Map<String, RemoteDebugger> myThreadIdToDebugger = Maps.newHashMap();

        private ThreadRegistry() {
        }

        public void register(String id, RemoteDebugger debugger) {
            this.myThreadIdToDebugger.put(id, debugger);
        }

        public RemoteDebugger getDebugger(String threadId) {
            return this.myThreadIdToDebugger.get(threadId);
        }

        public static String threadName(@NotNull String name, @NotNull String id) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$ThreadRegistry", "threadName"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$ThreadRegistry", "threadName"));
            }
            int indx = id.indexOf("_");
            if (indx != -1) {
                id = id.substring(0, indx);
            }
            return name + "(" + id + ")";
        }
    }
}

