/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadSourceCommand
extends AbstractCommand {
    private final String myPath;
    private String myContent;

    protected LoadSourceCommand(@NotNull RemoteDebugger debugger, String path) {
        if (debugger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugger", "com/jetbrains/python/debugger/pydev/LoadSourceCommand", "<init>"));
        }
        super(debugger, 124);
        this.myContent = null;
        this.myPath = path;
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        super.processResponse(response);
        this.myContent = ProtocolParser.parseSourceContent(response.getPayload());
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        payload.add(this.myPath);
    }

    @Nullable
    public String getContent() {
        return this.myContent;
    }
}

