/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.util.List;

public class GetFrameCommand
extends AbstractFrameCommand {
    protected final IPyDebugProcess myDebugProcess;
    private XValueChildrenList myFrameVariables = null;

    public GetFrameCommand(RemoteDebugger debugger, String threadId, String frameId) {
        this(debugger, 114, threadId, frameId);
    }

    protected GetFrameCommand(RemoteDebugger debugger, int command, String threadId, String frameId) {
        super(debugger, command, threadId, frameId);
        this.myDebugProcess = debugger.getDebugProcess();
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME");
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        super.processResponse(response);
        List<PyDebugValue> values = ProtocolParser.parseValues(response.getPayload(), this.myDebugProcess);
        this.myFrameVariables = new XValueChildrenList(values.size());
        for (PyDebugValue value : values) {
            if (value.getName().startsWith("__py_debug_temp_var_")) continue;
            PyDebugValue debugValue = this.extend(value);
            this.myFrameVariables.add(debugValue.getName(), (XValue)debugValue);
        }
    }

    protected PyDebugValue extend(PyDebugValue value) {
        return new PyDebugValue(value.getName(), value.getType(), value.getValue(), value.isContainer(), value.isErrorOnEval(), null, this.myDebugProcess);
    }

    public XValueChildrenList getVariables() {
        return this.myFrameVariables;
    }
}

