/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Lists;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PydevXmlUtils;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GetCompletionsCommand
extends AbstractFrameCommand {
    private String myActionToken;
    private List<PydevCompletionVariant> myCompletions = null;

    public GetCompletionsCommand(RemoteDebugger debugger, String threadId, String frameId, String myActionToken) {
        super(debugger, 120, threadId, frameId);
        this.myActionToken = myActionToken;
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        super.processResponse(response);
        try {
            this.myCompletions = PydevXmlUtils.xmlToCompletions(response.getPayload(), this.myActionToken);
        }
        catch (Exception e) {
            throw new PyDebuggerException("cant obtain completions", e);
        }
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myActionToken);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions() {
        if (this.myCompletions != null) {
            List<PydevCompletionVariant> list = this.myCompletions;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/GetCompletionsCommand", "getCompletions"));
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/GetCompletionsCommand", "getCompletions"));
        }
        return arrayList;
    }
}

