/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.GetFrameCommand;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;

public class GetArrayCommand
extends GetFrameCommand {
    private final PyDebugValue myParent;
    private final String myVariableName;
    private final int myRowOffset;
    private final int myColOffset;
    private final int myRows;
    private final int myColumns;
    private final String myFormat;
    private ArrayChunk myChunk;

    public GetArrayCommand(RemoteDebugger debugger, String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) {
        super(debugger, 143, threadId, frameId);
        this.myVariableName = GetVariableCommand.composeName(var);
        this.myRowOffset = rowOffset;
        this.myColOffset = colOffset;
        this.myRows = rows;
        this.myColumns = cols;
        this.myFormat = format;
        this.myParent = var;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        payload.add(this.myRowOffset);
        payload.add(this.myColOffset);
        payload.add(this.myRows);
        payload.add(this.myColumns);
        payload.add(this.myFormat);
        if (this.myParent.getVariableLocator() != null) {
            payload.add(this.myParent.getVariableLocator().getThreadId()).add(this.myParent.getVariableLocator().getPyDBLocation());
        } else if (this.myVariableName.contains("BY_ID")) {
            payload.add(this.getThreadId()).add(this.myVariableName);
        } else {
            super.buildPayload(payload);
            payload.add(this.myVariableName);
        }
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        if (response.getCommand() >= 900 && response.getCommand() < 1000) {
            throw new PyDebuggerException(response.getPayload());
        }
        this.myChunk = ProtocolParser.parseArrayValues(response.getPayload(), (PyFrameAccessor)this.myDebugProcess);
    }

    public ArrayChunk getArray() {
        return this.myChunk;
    }
}

