/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;

public class EvaluateCommand
extends AbstractFrameCommand {
    private final String myExpression;
    private final boolean myExecute;
    private final IPyDebugProcess myDebugProcess;
    private final boolean myTrimResult;
    private PyDebugValue myValue = null;

    public EvaluateCommand(RemoteDebugger debugger, String threadId, String frameId, String expression, boolean execute, boolean trimResult) {
        super(debugger, execute ? 115 : 113, threadId, frameId);
        this.myExpression = expression;
        this.myExecute = execute;
        this.myDebugProcess = debugger.getDebugProcess();
        this.myTrimResult = trimResult;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myExpression).add(this.myTrimResult);
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        super.processResponse(response);
        PyDebugValue value = ProtocolParser.parseValue(response.getPayload(), (PyFrameAccessor)this.myDebugProcess);
        this.myValue = value.setName(this.myExecute ? "" : this.myExpression);
    }

    public PyDebugValue getValue() {
        return this.myValue;
    }
}

