/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;

public class ChangeVariableCommand
extends AbstractFrameCommand {
    private final String myVariableName;
    private final String myValue;
    private PyDebugValue myNewValue = null;
    private final IPyDebugProcess myDebugProcess;

    public ChangeVariableCommand(RemoteDebugger debugger, String threadId, String frameId, String variableName, String value) {
        super(debugger, 117, threadId, frameId);
        this.myVariableName = variableName;
        this.myValue = value;
        this.myDebugProcess = debugger.getDebugProcess();
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myVariableName).add(ProtocolParser.encodeExpression(this.myValue));
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        super.processResponse(response);
        this.myNewValue = ProtocolParser.parseValue(response.getPayload(), (PyFrameAccessor)this.myDebugProcess).setName(this.myVariableName);
    }

    public PyDebugValue getNewValue() {
        return this.myNewValue;
    }
}

