/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.application.ApplicationManager;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommand<T> {
    public static final int RUN = 101;
    public static final int CREATE_THREAD = 103;
    public static final int KILL_THREAD = 104;
    public static final int SUSPEND_THREAD = 105;
    public static final int RESUME_THREAD = 106;
    public static final int STEP_INTO = 107;
    public static final int STEP_OVER = 108;
    public static final int STEP_OUT = 109;
    public static final int GET_VARIABLE = 110;
    public static final int SET_BREAKPOINT = 111;
    public static final int REMOVE_BREAKPOINT = 112;
    public static final int EVALUATE = 113;
    public static final int GET_FRAME = 114;
    public static final int EXECUTE = 115;
    public static final int WRITE_TO_CONSOLE = 116;
    public static final int CHANGE_VARIABLE = 117;
    public static final int GET_COMPLETIONS = 120;
    public static final int CONSOLE_EXEC = 121;
    public static final int ADD_EXCEPTION_BREAKPOINT = 122;
    public static final int REMOVE_EXCEPTION_BREAKPOINT = 123;
    public static final int LOAD_SOURCE = 124;
    public static final int SMART_STEP_INTO = 128;
    public static final int EXIT = 129;
    public static final int CALL_SIGNATURE_TRACE = 130;
    public static final int CMD_SET_PY_EXCEPTION = 131;
    public static final int CMD_GET_FILE_CONTENTS = 132;
    public static final int CMD_SET_PROPERTY_TRACE = 133;
    public static final int CMD_EVALUATE_CONSOLE_EXPRESSION = 134;
    public static final int CMD_RUN_CUSTOM_OPERATION = 135;
    public static final int CMD_GET_BREAKPOINT_EXCEPTION = 136;
    public static final int CMD_STEP_CAUGHT_EXCEPTION = 137;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE = 138;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE_PROCEEDED = 139;
    public static final int CMD_IGNORE_THROWN_EXCEPTION_AT = 140;
    public static final int CMD_ENABLE_DONT_TRACE = 141;
    public static final int SHOW_CONSOLE = 142;
    public static final int ERROR = 901;
    public static final int VERSION = 501;
    public static final String NEW_LINE_CHAR = "@_@NEW_LINE_CHAR@_@";
    public static final String TAB_CHAR = "@_@TAB_CHAR@_@";
    public static final int GET_ARRAY = 143;
    @NotNull
    private final RemoteDebugger myDebugger;
    private final int myCommandCode;
    private final ResponseProcessor<T> myResponseProcessor;

    protected AbstractCommand(@NotNull RemoteDebugger debugger, int commandCode) {
        if (debugger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugger", "com/jetbrains/python/debugger/pydev/AbstractCommand", "<init>"));
        }
        this.myDebugger = debugger;
        this.myCommandCode = commandCode;
        this.myResponseProcessor = this.createResponseProcessor();
    }

    protected ResponseProcessor<T> createResponseProcessor() {
        return null;
    }

    protected ResponseProcessor<T> getResponseProcessor() {
        return this.myResponseProcessor;
    }

    @NotNull
    public final String getPayload() {
        Payload payload = new Payload();
        this.buildPayload(payload);
        String string = payload.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/AbstractCommand", "getPayload"));
        }
        return string;
    }

    protected abstract void buildPayload(Payload var1);

    public boolean isResponseExpected() {
        return false;
    }

    public void execute() throws PyDebuggerException {
        int sequence = this.myDebugger.getNextSequence();
        ResponseProcessor<T> processor = this.getResponseProcessor();
        if (processor != null || this.isResponseExpected()) {
            this.myDebugger.placeResponse(sequence, null);
        }
        ProtocolFrame frame = new ProtocolFrame(this.myCommandCode, sequence, this.getPayload());
        boolean frameSent = this.myDebugger.sendFrame(frame);
        if (processor == null && !this.isResponseExpected()) {
            return;
        }
        if (!frameSent) {
            throw new PyDebuggerException("Couldn't send frame " + this.myCommandCode);
        }
        frame = this.myDebugger.waitForResponse(sequence);
        if (frame == null) {
            if (!this.myDebugger.isConnected()) {
                throw new PyDebuggerException("No connection (command:  " + this.myCommandCode + " )");
            }
            throw new PyDebuggerException("Timeout waiting for response on " + this.myCommandCode);
        }
        if (processor != null) {
            processor.processResponse(frame);
        } else {
            this.processResponse(frame);
        }
    }

    public void execute(final PyDebugCallback<T> callback) {
        final int sequence = this.myDebugger.getNextSequence();
        final ResponseProcessor<T> processor = this.getResponseProcessor();
        if (processor != null) {
            this.myDebugger.placeResponse(sequence, null);
        }
        try {
            ProtocolFrame frame = new ProtocolFrame(this.myCommandCode, sequence, this.getPayload());
            boolean frameSent = this.myDebugger.sendFrame(frame);
            if (processor == null) {
                return;
            }
            if (!frameSent) {
                throw new PyDebuggerException("Couldn't send frame " + this.myCommandCode);
            }
        }
        catch (PyDebuggerException e) {
            callback.error(e);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProtocolFrame frame = AbstractCommand.this.myDebugger.waitForResponse(sequence);
                    if (frame == null) {
                        if (!AbstractCommand.this.myDebugger.isConnected()) {
                            throw new PyDebuggerException("No connection (command:  " + AbstractCommand.this.myCommandCode + " )");
                        }
                        throw new PyDebuggerException("Timeout waiting for response on " + AbstractCommand.this.myCommandCode);
                    }
                    callback.ok(processor.processResponse(frame));
                }
                catch (PyDebuggerException e) {
                    callback.error(e);
                }
            }
        });
    }

    protected void processResponse(ProtocolFrame response) throws PyDebuggerException {
        if (response.getCommand() >= 900 && response.getCommand() < 1000) {
            throw new PyDebuggerException(response.getPayload());
        }
    }

    public static boolean isCallSignatureTrace(int command) {
        return command == 130;
    }

    public static boolean isWriteToConsole(int command) {
        return command == 116;
    }

    public static boolean isExitEvent(int command) {
        return command == 129;
    }

    public static boolean isErrorEvent(int command) {
        return command == 901;
    }

    @NotNull
    public RemoteDebugger getDebugger() {
        RemoteDebugger remoteDebugger = this.myDebugger;
        if (remoteDebugger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/pydev/AbstractCommand", "getDebugger"));
        }
        return remoteDebugger;
    }

    protected static class Payload {
        private final StringBuilder myBuilder = new StringBuilder();
        private static final char SEPARATOR = '\t';

        protected Payload() {
        }

        public Payload add(boolean flag) {
            return this.doAdd(flag ? "1" : "0");
        }

        public Payload add(int value) {
            return this.doAdd(String.valueOf(value));
        }

        public Payload add(String text) {
            return this.doAdd(text);
        }

        private Payload doAdd(String text) {
            if (this.myBuilder.length() > 0) {
                return this.separator().append(text);
            }
            return this.append(text);
        }

        private Payload append(String text) {
            this.myBuilder.append(ProtocolParser.encodeExpression(text));
            return this;
        }

        private Payload separator() {
            this.myBuilder.append('\t');
            return this;
        }

        public String getText() {
            return this.myBuilder.toString();
        }
    }

    protected static abstract class ResponseProcessor<T> {
        protected ResponseProcessor() {
        }

        protected T processResponse(ProtocolFrame response) throws PyDebuggerException {
            if (response.getCommand() >= 900 && response.getCommand() < 1000) {
                throw new PyDebuggerException(response.getPayload());
            }
            return this.parseResponse(response);
        }

        protected abstract T parseResponse(ProtocolFrame var1) throws PyDebuggerException;
    }
}

