/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyTypeHandler;
import org.jetbrains.annotations.NotNull;

public class PyValueModifier
extends XValueModifier {
    private final PyFrameAccessor myDebugProcess;
    private final PyDebugValue myVariable;

    public PyValueModifier(PyFrameAccessor debugProcess, PyDebugValue variable) {
        this.myDebugProcess = debugProcess;
        this.myVariable = variable;
    }

    public void setValue(final @NotNull String expression, final @NotNull XValueModifier.XModificationCallback callback) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/debugger/PyValueModifier", "setValue"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/debugger/PyValueModifier", "setValue"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    PyValueModifier.this.myDebugProcess.changeVariable(PyValueModifier.this.myVariable, expression);
                    callback.valueModified();
                }
                catch (PyDebuggerException e) {
                    callback.errorOccurred(e.getTracebackError());
                }
            }
        });
    }

    public String getInitialValueEditorText() {
        return PyTypeHandler.format(this.myVariable);
    }
}

