/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySignature {
    private final String myFile;
    private final String myFunctionName;
    private final List<NamedParameter> myArgs;

    public PySignature(@NotNull String file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignature", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignature", "<init>"));
        }
        this.myArgs = Lists.newArrayList();
        this.myFile = file;
        this.myFunctionName = name;
    }

    @Nullable
    public String getArgTypeQualifiedName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignature", "getArgTypeQualifiedName"));
        }
        for (NamedParameter param : this.myArgs) {
            if (!name.equals(param.getName())) continue;
            return param.getTypeQualifiedName();
        }
        return null;
    }

    @NotNull
    public String getFile() {
        String string = this.myFile;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignature", "getFile"));
        }
        return string;
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignature", "getFunctionName"));
        }
        return string;
    }

    @NotNull
    public List<NamedParameter> getArgs() {
        List<NamedParameter> list = this.myArgs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignature", "getArgs"));
        }
        return list;
    }

    @NotNull
    public PySignature addAllArgs(@NotNull PySignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/python/debugger/PySignature", "addAllArgs"));
        }
        for (NamedParameter param : signature.getArgs()) {
            NamedParameter ourParam = this.getArgForName(param.getName());
            if (ourParam != null) {
                ourParam.addTypes(param.getTypesList());
                continue;
            }
            this.addArgument(param);
        }
        PySignature pySignature = this;
        if (pySignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignature", "addAllArgs"));
        }
        return pySignature;
    }

    @Nullable
    private NamedParameter getArgForName(String name) {
        for (NamedParameter param : this.myArgs) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public PySignature addArgument(String name, String type) {
        return this.addArgument(new NamedParameter(name, type));
    }

    public PySignature addArgument(NamedParameter argument) {
        this.myArgs.add(argument);
        return this;
    }

    public static class NamedParameter {
        private final String myName;
        private final List<String> myTypes;

        private NamedParameter(@NotNull String name, @NotNull String type) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignature$NamedParameter", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/debugger/PySignature$NamedParameter", "<init>"));
            }
            this.myName = name;
            this.myTypes = NamedParameter.parseTypes(type);
        }

        @NotNull
        private static List<String> parseTypes(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/debugger/PySignature$NamedParameter", "parseTypes"));
            }
            Object[] parts = type.split(" or ");
            ArrayList arrayList = Lists.newArrayList((Object[])parts);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignature$NamedParameter", "parseTypes"));
            }
            return arrayList;
        }

        public String getName() {
            return this.myName;
        }

        public String getTypeQualifiedName() {
            if (this.myTypes.size() == 1) {
                return this.myTypes.get(0);
            }
            return StringUtil.join(this.myTypes, (String)" or ");
        }

        public void addType(String type) {
            if (!this.myTypes.contains(type)) {
                this.myTypes.add(type);
            }
        }

        public void addTypes(List<String> newTypes) {
            for (String type : newTypes) {
                this.addType(type);
            }
        }

        public List<String> getTypesList() {
            return this.myTypes;
        }
    }
}

