/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import org.jetbrains.annotations.NotNull;

public class PyReferringObjectsValue
extends PyDebugValue {
    private static final Logger LOG = Logger.getInstance(PyReferringObjectsValue.class);
    @NotNull
    private final PyReferrersLoader myReferrersLoader;

    public PyReferringObjectsValue(@NotNull String name, String type, String value, boolean container, boolean errorOnEval, @NotNull PyFrameAccessor frameAccessor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PyReferringObjectsValue", "<init>"));
        }
        if (frameAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameAccessor", "com/jetbrains/python/debugger/PyReferringObjectsValue", "<init>"));
        }
        super(name, type, value, container, errorOnEval, frameAccessor);
        this.myReferrersLoader = frameAccessor.getReferrersLoader();
    }

    public PyReferringObjectsValue(PyDebugValue debugValue) {
        this(debugValue.getName(), debugValue.getType(), debugValue.getValue(), debugValue.isContainer(), debugValue.isErrorOnEval(), debugValue.getFrameAccessor());
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyReferringObjectsValue", "computeChildren"));
        }
        if (node.isObsolete()) {
            return;
        }
        this.myReferrersLoader.loadReferrers(this, new PyDebugCallback<XValueChildrenList>(){

            @Override
            public void ok(XValueChildrenList value) {
                if (!node.isObsolete()) {
                    node.addChildren(value, true);
                }
            }

            @Override
            public void error(PyDebuggerException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage("Unable to display children:" + e.getMessage());
                }
                LOG.warn((Throwable)e);
            }
        });
    }

    public boolean isField() {
        return false;
    }
}

