/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import org.jetbrains.annotations.NotNull;

public class PyFullValueEvaluator
extends XFullValueEvaluator {
    private final PyFrameAccessor myDebugProcess;
    private final String myExpression;

    protected PyFullValueEvaluator(PyFrameAccessor debugProcess, String expression) {
        this.myDebugProcess = debugProcess;
        this.myExpression = expression;
    }

    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/debugger/PyFullValueEvaluator", "startEvaluation"));
        }
        String expression = this.myExpression.trim();
        if ("".equals(expression)) {
            callback.evaluated("");
            return;
        }
        try {
            PyDebugValue value = this.myDebugProcess.evaluate(expression, false, false);
            callback.evaluated(value.getValue());
        }
        catch (PyDebuggerException e) {
            callback.errorOccurred(e.getTracebackError());
        }
    }
}

