/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFullValueEvaluator;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyTypeHandler;
import com.jetbrains.python.debugger.PyValueModifier;
import com.jetbrains.python.debugger.pydev.PyVariableLocator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugValue
extends XNamedValue {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.pydev.PyDebugValue");
    public static final int MAX_VALUE = 256;
    private String myTempName;
    private final String myType;
    private final String myValue;
    private final boolean myContainer;
    private final PyDebugValue myParent;
    private String myId;
    private final PyFrameAccessor myFrameAccessor;
    private PyVariableLocator myVariableLocator;
    private final boolean myErrorOnEval;

    public PyDebugValue(@NotNull String name, String type, String value, boolean container, boolean errorOnEval, PyFrameAccessor frameAccessor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PyDebugValue", "<init>"));
        }
        this(name, type, value, container, errorOnEval, null, frameAccessor);
    }

    public PyDebugValue(@NotNull String name, String type, String value, boolean container, boolean errorOnEval, PyDebugValue parent, PyFrameAccessor frameAccessor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PyDebugValue", "<init>"));
        }
        super(name);
        this.myTempName = null;
        this.myId = null;
        this.myType = type;
        this.myValue = value;
        this.myContainer = container;
        this.myErrorOnEval = errorOnEval;
        this.myParent = parent;
        this.myFrameAccessor = frameAccessor;
    }

    public String getTempName() {
        return this.myTempName != null ? this.myTempName : this.myName;
    }

    public void setTempName(String tempName) {
        this.myTempName = tempName;
    }

    public String getType() {
        return this.myType;
    }

    public String getValue() {
        return this.myValue;
    }

    public boolean isContainer() {
        return this.myContainer;
    }

    public boolean isErrorOnEval() {
        return this.myErrorOnEval;
    }

    public PyDebugValue setParent(@Nullable PyDebugValue parent) {
        return new PyDebugValue(this.myName, this.myType, this.myValue, this.myContainer, this.myErrorOnEval, parent, this.myFrameAccessor);
    }

    public PyDebugValue getParent() {
        return this.myParent;
    }

    public PyDebugValue getTopParent() {
        return this.myParent == null ? this : this.myParent.getTopParent();
    }

    public String getEvaluationExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildExpression(stringBuilder);
        return stringBuilder.toString();
    }

    void buildExpression(StringBuilder result) {
        if (this.myParent == null) {
            result.append(this.getTempName());
        } else {
            this.myParent.buildExpression(result);
            if (("dict".equals(this.myParent.getType()) || "list".equals(this.myParent.getType()) || "tuple".equals(this.myParent.getType())) && !PyDebugValue.isLen(this.myName)) {
                result.append('[').append(PyDebugValue.removeLeadingZeros(PyDebugValue.removeId(this.myName))).append(']');
            } else if (!"set".equals(this.myParent.getType()) || PyDebugValue.isLen(this.myName)) {
                if (PyDebugValue.isLen(this.myName)) {
                    result.append('.').append(this.myName).append("()");
                } else if (("ndarray".equals(this.myParent.getType()) || "matrix".equals(this.myParent.getType())) && this.myName.startsWith("[")) {
                    result.append(PyDebugValue.removeLeadingZeros(this.myName));
                } else {
                    result.append('.').append(this.myName);
                }
            }
        }
    }

    private static String removeId(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PyDebugValue", "removeId"));
        }
        if (name.indexOf(40) != -1) {
            name = name.substring(0, name.indexOf(40)).trim();
        }
        return name;
    }

    private static String removeLeadingZeros(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PyDebugValue", "removeLeadingZeros"));
        }
        return name.replaceFirst("^0+(?!$)", "");
    }

    private static boolean isLen(String name) {
        return "__len__".equals(name);
    }

    private String getFullName() {
        String result = this.myName;
        for (PyDebugValue parent = this.myParent; parent != null; parent = parent.getParent()) {
            result = "." + result;
            result = parent.getName() + result;
        }
        return result;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyDebugValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/python/debugger/PyDebugValue", "computePresentation"));
        }
        String value = PyTypeHandler.format(this);
        if (value.length() >= 256) {
            node.setFullValueEvaluator((XFullValueEvaluator)new PyFullValueEvaluator(this.myFrameAccessor, this.getFullName()));
            value = value.substring(0, 256);
        }
        node.setPresentation(this.getValueIcon(), this.myType, value, this.myContainer);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyDebugValue", "computeChildren"));
        }
        if (node.isObsolete()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (PyDebugValue.this.myFrameAccessor == null) {
                    return;
                }
                try {
                    XValueChildrenList values = PyDebugValue.this.myFrameAccessor.loadVariable(PyDebugValue.this);
                    if (!node.isObsolete()) {
                        node.addChildren(values, true);
                    }
                }
                catch (PyDebuggerException e) {
                    if (!node.isObsolete()) {
                        node.setErrorMessage("Unable to display children:" + e.getMessage());
                    }
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    public XValueModifier getModifier() {
        return new PyValueModifier(this.myFrameAccessor, this);
    }

    private Icon getValueIcon() {
        if (!this.myContainer) {
            return AllIcons.Debugger.Db_primitive;
        }
        if ("list".equals(this.myType) || "tuple".equals(this.myType)) {
            return AllIcons.Debugger.Db_array;
        }
        return AllIcons.Debugger.Value;
    }

    public PyDebugValue setName(String newName) {
        return new PyDebugValue(newName, this.myType, this.myValue, this.myContainer, this.myErrorOnEval, this.myParent, this.myFrameAccessor);
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        if (this.myFrameAccessor.getReferrersLoader() != null) {
            return new XReferrersProvider(){

                public XValue getReferringObjectsValue() {
                    return new PyReferringObjectsValue(PyDebugValue.this);
                }
            };
        }
        return null;
    }

    public PyFrameAccessor getFrameAccessor() {
        return this.myFrameAccessor;
    }

    public PyVariableLocator getVariableLocator() {
        return this.myVariableLocator;
    }

    public void setVariableLocator(PyVariableLocator variableLocator) {
        this.myVariableLocator = variableLocator;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }
}

