/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.pydev;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.pydev.IPydevXmlRpcClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class PydevXmlRpcClient
implements IPydevXmlRpcClient {
    private final XmlRpcClient impl;
    private final Process process;
    private static final Logger LOG = Logger.getInstance((String)PydevXmlRpcClient.class.getName());
    private static final long TIME_LIMIT = 60000L;

    public PydevXmlRpcClient(Process process, int port) throws MalformedURLException {
        XmlRpc.setDefaultInputEncoding((String)"UTF8");
        this.impl = new XmlRpcClientLite(NetUtils.getLocalHostString(), port);
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String command, Object[] args) throws XmlRpcException {
        final Object[] result = new Object[]{null};
        this.impl.executeAsync(command, new Vector<Object>(Arrays.asList(args)), new AsyncCallback(){

            public void handleError(Exception error, URL url, String method) {
                result[0] = new Object[]{error.getMessage()};
            }

            public void handleResult(Object recievedResult, URL url, String method) {
                result[0] = recievedResult;
            }
        });
        long started = System.currentTimeMillis();
        while (result[0] == null && System.currentTimeMillis() - started < 60000L) {
            try {
                if (this.process == null) continue;
                int exitValue = this.process.exitValue();
                result[0] = new Object[]{String.format("Console already exited with value: %s while waiting for an answer.\n", exitValue)};
                break;
            }
            catch (IllegalThreadStateException e) {
                PydevXmlRpcClient pydevXmlRpcClient = this;
                synchronized (pydevXmlRpcClient) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error((Throwable)e1);
                    }
                }
            }
        }
        if (result[0] == null) {
            throw new XmlRpcException(-1, "Timeout while connecting to server");
        }
        return result[0];
    }
}

