/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserDetailed;

class GithubUserRaw
implements DataConstructor {
    @Nullable
    public String login;
    @Nullable
    public Long id;
    @Nullable
    public String url;
    @Nullable
    public String htmlUrl;
    @Nullable
    public String name;
    @Nullable
    public String email;
    @Nullable
    public String company;
    @Nullable
    public String location;
    @Nullable
    public String type;
    @Nullable
    public Integer publicRepos;
    @Nullable
    public Integer publicGists;
    @Nullable
    public Integer totalPrivateRepos;
    @Nullable
    public Integer ownedPrivateRepos;
    @Nullable
    public Integer privateGists;
    @Nullable
    public Long diskUsage;
    @Nullable
    public Integer followers;
    @Nullable
    public Integer following;
    @Nullable
    public String avatarUrl;
    @Nullable
    public String gravatarId;
    @Nullable
    public Integer collaborators;
    @Nullable
    public String blog;
    @Nullable
    public UserPlanRaw plan;
    @Nullable
    public Date createdAt;

    GithubUserRaw() {
    }

    @NotNull
    public GithubUser createUser() {
        GithubUser githubUser = new GithubUser(this.login, this.htmlUrl, this.avatarUrl);
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubUserRaw", "createUser"));
        }
        return githubUser;
    }

    @NotNull
    public GithubUserDetailed createUserDetailed() {
        GithubUserDetailed.UserPlan plan = this.plan == null ? null : this.plan.create();
        GithubUserDetailed githubUserDetailed = new GithubUserDetailed(this.login, this.htmlUrl, this.avatarUrl, this.name, this.email, this.ownedPrivateRepos, this.type, plan);
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubUserRaw", "createUserDetailed"));
        }
        return githubUserDetailed;
    }

    @Override
    @NotNull
    public <T> T create(@NotNull Class<T> resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubUserRaw", "create"));
        }
        if (resultClass == GithubUser.class) {
            GithubUser githubUser = this.createUser();
            if (githubUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubUserRaw", "create"));
            }
            return (T)githubUser;
        }
        if (resultClass == GithubUserDetailed.class) {
            GithubUserDetailed githubUserDetailed = this.createUserDetailed();
            if (githubUserDetailed == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubUserRaw", "create"));
            }
            return (T)githubUserDetailed;
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class UserPlanRaw {
        @Nullable
        public String name;
        @Nullable
        public Long space;
        @Nullable
        public Long collaborators;
        @Nullable
        public Long privateRepos;

        @NotNull
        public GithubUserDetailed.UserPlan create() {
            GithubUserDetailed.UserPlan userPlan = new GithubUserDetailed.UserPlan(this.name, this.privateRepos);
            if (userPlan == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubUserRaw$UserPlanRaw", "create"));
            }
            return userPlan;
        }
    }
}

