/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgReferenceValidator
implements InputValidatorEx {
    private final HgRepository myRepository;
    private String myErrorText;
    private static final Pattern ILLEGAL = Pattern.compile(".*:.*|[0-9]*");

    private HgReferenceValidator(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgReferenceValidator", "<init>"));
        }
        this.myRepository = repository;
    }

    public static HgReferenceValidator newInstance(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgReferenceValidator", "newInstance"));
        }
        return new HgReferenceValidator(repository);
    }

    public boolean checkInput(@Nullable String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (ILLEGAL.matcher(name).matches()) {
            this.myErrorText = "Invalid name for branch/tag";
            return false;
        }
        return !this.isReservedWord(name) && !this.hasConflictsWithAnotherBranch(name);
    }

    public boolean canClose(@Nullable String name) {
        return this.checkInput(name);
    }

    boolean isReservedWord(@Nullable String name) {
        this.myErrorText = "tip".equals(name) ? String.format("The name '%s' is reserved.", name) : null;
        return this.myErrorText != null;
    }

    boolean hasConflictsWithAnotherBranch(@Nullable String name) {
        Set<String> branches = this.myRepository.getBranches().keySet();
        String currentBranch = this.myRepository.getCurrentBranch();
        this.myErrorText = currentBranch.equals(name) || branches.contains(name) ? String.format("A branch with the '%s' name already exists", name) : null;
        return this.myErrorText != null;
    }

    @Nullable
    public String getErrorText(@Nullable String inputString) {
        return this.myErrorText;
    }
}

