/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.ui.HgHideableWidget;

public class HgIncomingOutgoingWidget
extends EditorBasedWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget.Multiframe,
HgUpdater,
HgHideableWidget {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    final Project myProject;
    @NotNull
    private final HgProjectSettings myProjectSettings;
    @NotNull
    private final HgChangesetStatus myChangesStatus;
    private final boolean myIsIncoming;
    private boolean isAlreadyShown;
    private MessageBusConnection myBusConnection;
    private volatile String myTooltip;
    private Icon myCurrentIcon;

    public HgIncomingOutgoingWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings, boolean isIncoming) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "<init>"));
        }
        super(project);
        this.myTooltip = "";
        this.myCurrentIcon = AllIcons.Ide.IncomingChangesOff;
        this.myProject = project;
        this.myIsIncoming = isIncoming;
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
        this.myChangesStatus = new HgChangesetStatus(isIncoming ? "In" : "Out");
        this.isAlreadyShown = false;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public StatusBarWidget copy() {
        return new HgIncomingOutgoingWidget(this.myVcs, this.myProject, this.myProjectSettings, this.myIsIncoming);
    }

    @NotNull
    public String ID() {
        String name = HgIncomingOutgoingWidget.class.getName();
        String string = this.myIsIncoming ? "In" + name : "Out" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "ID"));
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "getPresentation"));
        }
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "selectionChanged"));
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "fileOpened"));
        }
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "fileClosed"));
        }
        this.update();
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                HgIncomingOutgoingWidget.this.update();
            }
        };
    }

    public boolean isVisible() {
        return this.myProjectSettings.isCheckIncomingOutgoing();
    }

    @Override
    public void update(final Project project, @Nullable VirtualFile root) {
        if (!this.isVisible()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project == null || project.isDisposed()) {
                    HgIncomingOutgoingWidget.this.emptyTooltip();
                    return;
                }
                HgIncomingOutgoingWidget.this.emptyTooltip();
                HgIncomingOutgoingWidget.this.myCurrentIcon = AllIcons.Ide.IncomingChangesOff;
                if (HgIncomingOutgoingWidget.this.myChangesStatus.getNumChanges() > 0) {
                    HgIncomingOutgoingWidget.this.myCurrentIcon = HgIncomingOutgoingWidget.this.myIsIncoming ? AllIcons.Ide.IncomingChangesOn : AllIcons.Ide.OutgoingChangesOn;
                    HgIncomingOutgoingWidget.this.myTooltip = "\n" + HgIncomingOutgoingWidget.this.myChangesStatus.getToolTip();
                }
                HgIncomingOutgoingWidget.this.myStatusBar.updateWidget(HgIncomingOutgoingWidget.this.ID());
            }
        });
    }

    public void activate() {
        this.myBusConnection = this.myProject.getMessageBus().connect();
        this.myBusConnection.subscribe(HgVcs.STATUS_TOPIC, (Object)this);
        this.myBusConnection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)this);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (null != statusBar && this.isVisible()) {
            statusBar.addWidget((StatusBarWidget)this, (Disposable)this.myProject);
            this.isAlreadyShown = true;
        }
    }

    public void deactivate() {
        if (!this.isAlreadyShown) {
            return;
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (null != statusBar) {
            statusBar.removeWidget(this.ID());
            this.isAlreadyShown = false;
        }
    }

    @Override
    public void show() {
        if (this.isAlreadyShown) {
            return;
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (null != statusBar && this.isVisible()) {
            statusBar.addWidget((StatusBarWidget)this, (Disposable)this.myProject);
            this.isAlreadyShown = true;
            ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
        }
    }

    @Override
    public void hide() {
        this.deactivate();
    }

    private void update() {
        this.update(this.myProject, null);
    }

    private void emptyTooltip() {
        this.myTooltip = "";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget", "getIcon"));
        }
        return icon;
    }

    public HgChangesetStatus getChangesetStatus() {
        return this.myChangesStatus;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
        }
    }
}

