/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryImpl;

public class HgRepositoryManager
extends AbstractRepositoryManager<HgRepository> {
    private final HgProjectSettings mySettings;

    public HgRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/repo/HgRepositoryManager", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "org/zmlx/hg4idea/repo/HgRepositoryManager", "<init>"));
        }
        super(project, vcsManager, (AbstractVcs)HgVcs.getInstance(project), ".hg");
        this.mySettings = ((HgVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)HgVcs.getInstance(project))))).getProjectSettings();
    }

    @NotNull
    protected HgRepository createRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/repo/HgRepositoryManager", "createRepository"));
        }
        HgRepository hgRepository = HgRepositoryImpl.getInstance(root, this.myProject, (Disposable)this);
        if (hgRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryManager", "createRepository"));
        }
        return hgRepository;
    }

    public boolean isSyncEnabled() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new HgMultiRootBranchConfig(this.getRepositories()).diverged();
    }
}

