/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgUpdateCommand {
    private final Project project;
    private final VirtualFile repo;
    private String branch;
    private String revision;
    private boolean clean;

    public HgUpdateCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgUpdateCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HgCommandResult execute() {
        HgCommandResult result;
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.clean) {
            arguments.add("--clean");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        } else if (!StringUtil.isEmptyOrSpaces((String)this.branch)) {
            arguments.add(this.branch);
        }
        HgPromptCommandExecutor executor = new HgPromptCommandExecutor(this.project);
        executor.setShowOutput(true);
        DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            result = executor.executeInCurrentThread(this.repo, "update", arguments);
            if (!this.clean && HgErrorUtil.hasUncommittedChangesConflict(result)) {
                String message = "<html>Your uncommitted changes couldn't be merged into the requested changeset.<br>Would you like to perform force update and discard them?";
                if (HgUpdateCommand.showDiscardChangesConfirmation(this.project, "<html>Your uncommitted changes couldn't be merged into the requested changeset.<br>Would you like to perform force update and discard them?") == 0) {
                    arguments.add("-C");
                    result = executor.executeInCurrentThread(this.repo, "update", arguments);
                }
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project);
        }
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.repo});
        return result;
    }

    public static int showDiscardChangesConfirmation(final @NotNull Project project, final @NotNull String confirmationMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "showDiscardChangesConfirmation"));
        }
        if (confirmationMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationMessage", "org/zmlx/hg4idea/command/HgUpdateCommand", "showDiscardChangesConfirmation"));
        }
        final AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                exitCode.set(Messages.showOkCancelDialog((Project)project, (String)confirmationMessage, (String)"Uncommitted Changes Problem", (String)"&Discard Changes", (String)"&Cancel", (Icon)Messages.getWarningIcon()));
            }
        });
        return exitCode.get();
    }
}

