/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;

public class HgBranchCreateCommand {
    private final Project project;
    private final VirtualFile repo;
    private final String branchName;

    public HgBranchCreateCommand(@NotNull Project project, @NotNull VirtualFile repo, @Nullable String branchName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgBranchCreateCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgBranchCreateCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
        this.branchName = branchName;
    }

    public void execute(@Nullable HgCommandResultHandler resultHandler) throws HgCommandException {
        if (StringUtil.isEmptyOrSpaces((String)this.branchName)) {
            throw new HgCommandException("branch name is empty");
        }
        new HgCommandExecutor(this.project).execute(this.repo, "branch", Arrays.asList(this.branchName), resultHandler);
    }
}

