/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgBranchCreateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgBookmarkDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopupActions {
    private final Project myProject;
    private final HgRepository myRepository;

    HgBranchPopupActions(Project project, HgRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions(@Nullable DefaultActionGroup toInsert) {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addAction((AnAction)new HgNewBranchAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgNewBookmarkAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgShowUnnamedHeadsForCurrentBranchAction(this.myProject, this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Bookmarks");
        List<String> bookmarkNames = HgUtil.getNamesWithoutHashes(this.myRepository.getBookmarks());
        String currentBookmark = this.myRepository.getCurrentBookmark();
        for (String bookmark : bookmarkNames) {
            BookmarkActions bookmarkAction = new BookmarkActions(this.myProject, Collections.singletonList(this.myRepository), bookmark);
            if (bookmark.equals(currentBookmark)) {
                bookmarkAction.getTemplatePresentation().setIcon(PlatformIcons.CHECK_ICON);
            }
            popupGroup.add((AnAction)bookmarkAction);
        }
        popupGroup.addSeparator("Branches");
        ArrayList<String> branchNamesList = new ArrayList<String>(this.myRepository.getOpenedBranches());
        Collections.sort(branchNamesList);
        for (String branch : branchNamesList) {
            if (branch.equals(this.myRepository.getCurrentBranch())) continue;
            popupGroup.add((AnAction)new HgCommonBranchActions(this.myProject, Collections.singletonList(this.myRepository), branch));
        }
        return popupGroup;
    }

    static class BookmarkActions
    extends HgCommonBranchActions {
        BookmarkActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "<init>"));
            }
            super(project, repositories, branchName);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])super.getChildren(e), (Object)((Object)new DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)));
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions", "getChildren"));
            }
            return anActionArray;
        }

        private static class DeleteBookmarkAction
        extends HgBranchAbstractAction {
            DeleteBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction", "<init>"));
                }
                super(project, "Delete", repositories, branchName);
            }

            public void actionPerformed(AnActionEvent e) {
                for (HgRepository repository : this.myRepositories) {
                    try {
                        new HgBookmarkCommand(this.myProject, repository.getRoot(), this.myBranchName).deleteBookmark();
                    }
                    catch (HgCommandException exception) {
                        HgAbstractGlobalAction.handleException(this.myProject, exception);
                    }
                }
            }
        }
    }

    public static class HgShowUnnamedHeadsForCurrentBranchAction
    extends ActionGroup {
        @NotNull
        final Project myProject;
        @NotNull
        final HgRepository myRepository;
        @NotNull
        final String myCurrentBranchName;
        @NotNull
        Collection<Hash> myHeads;

        public HgShowUnnamedHeadsForCurrentBranchAction(@NotNull Project project, @NotNull HgRepository repository) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "<init>"));
            }
            super(null, true);
            this.myHeads = new HashSet<Hash>();
            this.myProject = project;
            this.myRepository = repository;
            this.myCurrentBranchName = repository.getCurrentBranch();
            this.getTemplatePresentation().setText(String.format("Unnamed heads for %s", this.myCurrentBranchName));
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    HgShowUnnamedHeadsForCurrentBranchAction.this.myHeads = HgShowUnnamedHeadsForCurrentBranchAction.this.filterUnnamedHeads();
                }
            });
        }

        @NotNull
        private Collection<Hash> filterUnnamedHeads() {
            Collection branchWithHashes = this.myRepository.getBranches().get(this.myCurrentBranchName);
            if (branchWithHashes == null) {
                Set<Hash> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "filterUnnamedHeads"));
                }
                return set;
            }
            List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(this.myRepository.getRoot());
            if (parents.size() == 1) {
                List bookmarkHashes = ContainerUtil.map(this.myRepository.getBookmarks(), (Function)new Function<HgNameWithHashInfo, Hash>(){

                    public Hash fun(HgNameWithHashInfo info) {
                        return info.getHash();
                    }
                });
                branchWithHashes.removeAll(bookmarkHashes);
                branchWithHashes.remove(HashImpl.build((String)parents.get(0).getChangeset()));
            }
            Collection collection = branchWithHashes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "filterUnnamedHeads"));
            }
            return collection;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<HgCommonBranchActions> branchHeadActions = new ArrayList<HgCommonBranchActions>();
            for (Hash hash : this.myHeads) {
                branchHeadActions.add(new HgCommonBranchActions(this.myProject, Collections.singletonList(this.myRepository), hash.toShortString()));
            }
            AnAction[] anActionArray = (AnAction[])ContainerUtil.toArray(branchHeadActions, (Object[])new AnAction[branchHeadActions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction", "getChildren"));
            }
            return anActionArray;
        }

        public void update(AnActionEvent e) {
            if (this.myRepository.isFresh()) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout of a new branch is not possible before the first commit.");
            } else if (!Repository.State.NORMAL.equals((Object)this.myRepository.getState())) {
                e.getPresentation().setEnabled(false);
            }
        }
    }

    public static class HgNewBookmarkAction
    extends DumbAwareAction {
        @NotNull
        protected final List<HgRepository> myRepositories;
        @NotNull
        protected Project myProject;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgNewBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction", "<init>"));
            }
            if (preselectedRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepo", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction", "<init>"));
            }
            super("New Bookmark", "Create new bookmark", null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void update(AnActionEvent e) {
            if (DvcsUtil.anyRepositoryIsFresh(this.myRepositories)) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Bookmark creation is not possible before the first commit.");
            }
        }

        public void actionPerformed(AnActionEvent e) {
            HgBookmarkDialog bookmarkDialog = new HgBookmarkDialog(this.myPreselectedRepo);
            bookmarkDialog.show();
            if (bookmarkDialog.isOK()) {
                String name = bookmarkDialog.getName();
                for (HgRepository repository : this.myRepositories) {
                    try {
                        new HgBookmarkCommand(this.myProject, repository.getRoot(), name).createBookmark(bookmarkDialog.isActive());
                    }
                    catch (HgCommandException exception) {
                        HgAbstractGlobalAction.handleException(this.myProject, exception);
                    }
                }
            }
        }
    }

    public static class HgNewBranchAction
    extends NewBranchAction<HgRepository> {
        @NotNull
        final HgRepository myPreselectedRepo;

        public HgNewBranchAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            if (preselectedRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepo", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "<init>"));
            }
            super(project, repositories);
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(AnActionEvent e) {
            String name = HgUtil.getNewBranchNameFromUser(this.myPreselectedRepo, "Create New Branch");
            if (name == null) {
                return;
            }
            this.createNewBranch(name);
        }

        public void createNewBranch(final @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction", "createNewBranch"));
            }
            for (final HgRepository repository : this.myRepositories) {
                try {
                    new HgBranchCreateCommand(this.myProject, repository.getRoot(), name).execute(new HgCommandResultHandler(){

                        @Override
                        public void process(@Nullable HgCommandResult result) {
                            repository.update();
                            if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                                new HgCommandResultNotifier(HgNewBranchAction.this.myProject).notifyError(result, "Creation failed", "Branch creation [" + name + "] failed");
                            }
                        }
                    });
                }
                catch (HgCommandException exception) {
                    HgAbstractGlobalAction.handleException(this.myProject, "Can't create new branch: ", exception);
                }
            }
        }
    }
}

