/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgUpdateToDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgUpdateToAction
extends HgAbstractGlobalSingleRepoAction {
    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgUpdateToAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/action/HgUpdateToAction", "execute"));
        }
        HgUpdateToDialog dialog = new HgUpdateToDialog(project, repositories, selectedRepo);
        dialog.show();
        if (dialog.isOK()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            final String updateToValue = StringUtil.escapeBackSlashes((String)dialog.getTargetValue());
            final boolean clean = dialog.isRemoveLocalChanges();
            final VirtualFile root = dialog.getRepository().getRoot();
            new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.updatingTo", updateToValue)){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgUpdateToAction$1", "run"));
                    }
                    HgUpdateToAction.updateTo(project, root, updateToValue, clean);
                }
            }.queue();
        }
    }

    public static boolean updateTo(@NotNull Project project, @NotNull VirtualFile root, @NotNull String updateToValue, boolean clean) {
        boolean hasUnresolvedConflicts;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgUpdateToAction", "updateTo"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/action/HgUpdateToAction", "updateTo"));
        }
        if (updateToValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateToValue", "org/zmlx/hg4idea/action/HgUpdateToAction", "updateTo"));
        }
        HgUpdateCommand command = new HgUpdateCommand(project, root);
        command.setRevision(updateToValue);
        command.setClean(clean);
        HgCommandResult result = command.execute();
        new HgConflictResolver(project).resolve(root);
        boolean success = !HgErrorUtil.isCommandExecutionFailed(result);
        boolean bl = hasUnresolvedConflicts = !HgConflictResolver.findConflicts(project, root).isEmpty();
        if (!success) {
            new HgCommandResultNotifier(project).notifyError(result, "", "Update failed");
        } else if (hasUnresolvedConflicts) {
            new VcsNotifier(project).notifyImportantWarning("Unresolved conflicts.", HgVcsMessages.message("hg4idea.update.warning.merge.conflicts", root.getPath()));
        }
        HgUpdateToAction.markDirtyAndHandleErrors(project, root);
        return success;
    }
}

