/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.HgProcessRebaseAction;
import org.zmlx.hg4idea.command.HgRebaseCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgAbortRebaseAction
extends HgProcessRebaseAction {
    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, final @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgAbortRebaseAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/action/HgAbortRebaseAction", "execute"));
        }
        new Task.Backgroundable(project, "Abort Rebasing..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgAbortRebaseAction$1", "run"));
                }
                if (selectedRepo != null) {
                    HgRebaseCommand rebaseCommand = new HgRebaseCommand(project, selectedRepo);
                    HgCommandResult result = rebaseCommand.abortRebase();
                    if (HgErrorUtil.isAbort(result)) {
                        new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't abort rebasing");
                    }
                    HgAbstractGlobalAction.markDirtyAndHandleErrors(project, selectedRepo.getRoot());
                }
            }
        }.queue();
    }
}

